/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.numbers;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.vaadin.miki.superfields.numbers.AbstractSuperFloatingPointField;

@Tag(value="super-double-field")
public class SuperDoubleField
extends AbstractSuperFloatingPointField<Double, SuperDoubleField> {
    public SuperDoubleField() {
        this("");
    }

    public SuperDoubleField(Locale locale) {
        this("", locale);
    }

    public SuperDoubleField(Locale locale, int maxFractionDigits) {
        this("", locale, maxFractionDigits);
    }

    public SuperDoubleField(String label) {
        this(label, Locale.getDefault());
    }

    public SuperDoubleField(String label, Locale locale) {
        this(label, locale, -1);
    }

    public SuperDoubleField(Double defaultValue, String label) {
        this(defaultValue, label, Locale.getDefault(), -1);
    }

    public SuperDoubleField(String label, Locale locale, int maxFractionDigits) {
        this(0.0, label, locale, maxFractionDigits);
    }

    public SuperDoubleField(Double defaultValue, String label, Locale locale, int maxFractionDigits) {
        super(defaultValue, (SerializablePredicate & Serializable)d -> d < 0.0, Math::abs, label, locale, maxFractionDigits);
    }

    @Override
    protected Double parseRawValue(String rawValue, DecimalFormat format) throws ParseException {
        return format.parse(rawValue).doubleValue();
    }
}

