/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.numbers;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.vaadin.miki.superfields.numbers.AbstractSuperNumberField;

@Tag(value="super-long-field")
public class SuperLongField
extends AbstractSuperNumberField<Long, SuperLongField> {
    public SuperLongField() {
        this("");
    }

    public SuperLongField(Locale locale) {
        this("", locale);
    }

    public SuperLongField(String label) {
        this(label, Locale.getDefault());
    }

    public SuperLongField(String label, Locale locale) {
        this(0L, label, locale);
    }

    public SuperLongField(Long defaultValue, String label) {
        this(defaultValue, label, Locale.getDefault());
    }

    public SuperLongField(Long defaultValue, String label, Locale locale) {
        super(defaultValue, (SerializablePredicate & Serializable)d -> d < 0L, Math::abs, label, locale, 0);
    }

    @Override
    protected Long parseRawValue(String rawValue, DecimalFormat format) throws ParseException {
        return format.parse(rawValue).longValue();
    }

    @Override
    public void setDecimalFormat(DecimalFormat format) {
        format.setMaximumFractionDigits(0);
        super.setDecimalFormat(format);
    }
}

