/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.collections;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.collections.CollectionField;
import org.vaadin.miki.superfields.collections.CollectionLayoutProvider;
import org.vaadin.miki.superfields.collections.CollectionValueComponentProvider;
import org.vaadin.miki.superfields.collections.WithCollectionElementFilterMixin;
import org.vaadin.miki.superfields.collections.WithCollectionValueComponentProviderMixin;
import org.vaadin.miki.superfields.layouts.FlexLayoutHelpers;

@CssImport(value="./styles/label-positions-custom-field.css", themeFor="vaadin-custom-field")
public class MapField<K, V>
extends CustomField<Map<K, V>>
implements HasStyle,
WithIdMixin<MapField<K, V>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<Map<K, V>>, Map<K, V>>, Map<K, V>, MapField<K, V>>,
WithHelperPositionableMixin<MapField<K, V>>,
WithHelperMixin<MapField<K, V>>,
WithLabelMixin<MapField<K, V>>,
WithCollectionValueComponentProviderMixin<Map.Entry<K, V>, MapField<K, V>>,
WithCollectionElementFilterMixin<Map.Entry<K, V>, MapField<K, V>>,
WithLabelPositionableMixin<MapField<K, V>> {
    private final SerializableSupplier<Map<K, V>> emptyMapSupplier;
    private final CollectionField<Map.Entry<K, V>, List<Map.Entry<K, V>>> collectionField;
    private SerializablePredicate<Map.Entry<K, V>> entryFilter = MapField.nonNullEntryFilter();

    public static <X, Y> SerializablePredicate<Map.Entry<X, Y>> nonNullEntryFilter() {
        return (SerializablePredicate & Serializable)e -> e != null && e.getKey() != null && e.getValue() != null;
    }

    public <L extends Component, C extends Component> MapField(SerializableSupplier<Map<K, V>> emptyMapSupplier, Supplier<L> layoutProvider, SerializableSupplier<C> entryComponentProvider) {
        this(emptyMapSupplier, (index, controller) -> (Component)layoutProvider.get(), (index, controller) -> (Component)entryComponentProvider.get());
    }

    public <L extends Component, C extends Component> MapField(Supplier<L> layoutProvider, SerializableSupplier<C> entryComponentProvider) {
        this(LinkedHashMap::new, layoutProvider, entryComponentProvider);
    }

    public <C extends Component> MapField(SerializableSupplier<C> entryComponentProvider) {
        this(FlexLayoutHelpers::column, entryComponentProvider);
    }

    public MapField(SerializableSupplier<Map<K, V>> emptyMapSupplier, CollectionLayoutProvider<?> mainLayoutProvider, CollectionValueComponentProvider<Map.Entry<K, V>, ?> entryValueComponentProvider) {
        super(emptyMapSupplier.get());
        this.emptyMapSupplier = emptyMapSupplier;
        this.collectionField = new CollectionField(ArrayList::new, mainLayoutProvider, entryValueComponentProvider);
        this.collectionField.addClassName("map-field-entry-collection");
        this.collectionField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateValue());
        this.add(new Component[]{this.collectionField});
    }

    protected Map<K, V> generateModelValue() {
        Map result = (Map)this.emptyMapSupplier.get();
        ((List)this.collectionField.getValue()).stream().filter(this.getCollectionElementFilter()).forEach(entry -> result.put(entry.getKey(), entry.getValue()));
        return result;
    }

    protected void setPresentationValue(Map<K, V> map) {
        this.collectionField.setValue(map == null ? Collections.emptyList() : new ArrayList<Map.Entry<K, V>>(map.entrySet()));
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.collectionField.setReadOnly(readOnly);
    }

    public void focus() {
        this.collectionField.focus();
    }

    @Override
    public void setCollectionValueComponentProvider(CollectionValueComponentProvider<Map.Entry<K, V>, ?> provider) {
        this.collectionField.setCollectionValueComponentProvider(provider);
    }

    @Override
    public <W extends Component> CollectionValueComponentProvider<Map.Entry<K, V>, W> getCollectionValueComponentProvider() {
        return this.collectionField.getCollectionValueComponentProvider();
    }

    @Override
    public void setCollectionElementFilter(SerializablePredicate<Map.Entry<K, V>> collectionElementFilter) {
        this.entryFilter = collectionElementFilter == null ? e -> true : collectionElementFilter;
    }

    @Override
    public SerializablePredicate<Map.Entry<K, V>> getCollectionElementFilter() {
        return this.entryFilter;
    }
}

