/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.dates;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.vaadin.miki.events.text.TextSelectionListener;
import org.vaadin.miki.events.text.TextSelectionNotifier;
import org.vaadin.miki.markers.CanReceiveSelectionEventsFromClient;
import org.vaadin.miki.markers.CanSelectText;
import org.vaadin.miki.markers.WithDatePatternMixin;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithLocaleMixin;
import org.vaadin.miki.markers.WithPlaceholderMixin;
import org.vaadin.miki.markers.WithReceivingSelectionEventsFromClientMixin;
import org.vaadin.miki.markers.WithRequiredMixin;
import org.vaadin.miki.markers.WithTooltipMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.shared.dates.DatePattern;
import org.vaadin.miki.shared.labels.LabelPosition;
import org.vaadin.miki.shared.text.TextSelectionDelegate;
import org.vaadin.miki.superfields.dates.DatePatternDelegate;
import org.vaadin.miki.superfields.dates.HasSuperDatePickerI18N;
import org.vaadin.miki.superfields.dates.SuperDatePickerI18n;
import org.vaadin.miki.superfields.dates.SuperDatePickerI18nHelper;

@JsModule(value="./super-date-picker.js")
@Tag(value="super-date-picker")
@CssImport(value="./styles/label-positions.css", themeFor="vaadin-date-picker-text-field")
public class SuperDatePicker
extends DatePicker
implements CanSelectText,
CanReceiveSelectionEventsFromClient,
WithReceivingSelectionEventsFromClientMixin<SuperDatePicker>,
TextSelectionNotifier<SuperDatePicker>,
HasSuperDatePickerI18N,
WithLabelPositionableMixin<SuperDatePicker>,
WithLocaleMixin<SuperDatePicker>,
WithLabelMixin<SuperDatePicker>,
WithPlaceholderMixin<SuperDatePicker>,
WithDatePatternMixin<SuperDatePicker>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>, LocalDate, SuperDatePicker>,
WithIdMixin<SuperDatePicker>,
WithHelperMixin<SuperDatePicker>,
WithHelperPositionableMixin<SuperDatePicker>,
WithRequiredMixin<SuperDatePicker>,
WithTooltipMixin<SuperDatePicker> {
    private final DatePatternDelegate<SuperDatePicker> datePatternDelegate = new DatePatternDelegate<SuperDatePicker>(this);
    private final TextSelectionDelegate<SuperDatePicker> textSelectionDelegate;
    private DatePattern datePattern;

    public SuperDatePicker() {
        this(Locale.getDefault());
    }

    public SuperDatePicker(Locale locale) {
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(locale);
    }

    public SuperDatePicker(LocalDate initialDate) {
        super(initialDate);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(Locale.getDefault());
    }

    public SuperDatePicker(String label) {
        super(label);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(Locale.getDefault());
    }

    public SuperDatePicker(String label, LocalDate initialDate) {
        super(label, initialDate);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(Locale.getDefault());
    }

    public SuperDatePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        super(listener);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(Locale.getDefault());
    }

    public SuperDatePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        super(label, listener);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(Locale.getDefault());
    }

    public SuperDatePicker(LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        super(initialDate, listener);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(Locale.getDefault());
    }

    public SuperDatePicker(String label, LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        super(label, initialDate, listener);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(Locale.getDefault());
    }

    public SuperDatePicker(LocalDate initialDate, Locale locale) {
        super(initialDate);
        this.textSelectionDelegate = new TextSelectionDelegate<SuperDatePicker>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)this::getFormattedValue));
        this.setLocale(locale);
    }

    @Override
    public final void setLocale(Locale locale) {
        if (this.datePatternDelegate != null) {
            this.datePatternDelegate.initPatternSetting();
            SuperDatePickerI18nHelper.updateI18N(locale, () -> ((SuperDatePicker)this).getI18n(), this::setI18n);
        }
        super.setLocale(locale);
    }

    @Override
    public void setDatePattern(DatePattern datePattern) {
        this.datePattern = datePattern;
        this.datePatternDelegate.updateClientSidePattern();
    }

    @Override
    public DatePattern getDatePattern() {
        return this.datePattern;
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.textSelectionDelegate.onAttach(attachEvent, event -> super.onAttach(event));
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.textSelectionDelegate.onDetach(detachEvent, event -> super.onDetach(event));
    }

    @ClientCallable
    private void selectionChanged(int start, int end, String selection) {
        this.textSelectionDelegate.fireTextSelectionEvent(true, start, end, selection);
    }

    @Override
    public boolean isReceivingSelectionEventsFromClient() {
        return this.textSelectionDelegate.isReceivingSelectionEventsFromClient();
    }

    @Override
    public void setReceivingSelectionEventsFromClient(boolean receivingSelectionEventsFromClient) {
        this.textSelectionDelegate.setReceivingSelectionEventsFromClient(receivingSelectionEventsFromClient);
    }

    public String getFormattedValue() {
        LocalDate value = (LocalDate)this.getValue();
        if (value == null) {
            return null;
        }
        if (this.getDatePattern() == null) {
            return value.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(this.getLocale()));
        }
        return this.datePatternDelegate.formatDate(value);
    }

    @Override
    public void selectAll() {
        this.textSelectionDelegate.selectAll();
    }

    @Override
    public void selectNone() {
        this.textSelectionDelegate.selectNone();
    }

    @Override
    public void select(int from, int to) {
        this.textSelectionDelegate.select(from, to);
    }

    @Override
    public Registration addTextSelectionListener(TextSelectionListener<SuperDatePicker> listener) {
        return this.textSelectionDelegate.addTextSelectionListener(listener);
    }

    @Override
    public SuperDatePickerI18n getSuperDatePickerI18n() {
        return (SuperDatePickerI18n)this.getI18n();
    }

    public void setI18n(DatePicker.DatePickerI18n i18n) {
        if (!(i18n instanceof SuperDatePickerI18n)) {
            i18n = SuperDatePickerI18nHelper.from(i18n, this.getLocale());
        }
        super.setI18n(i18n);
    }

    @Override
    public void setTooltipText(String title) {
        this.getElement().setProperty("title", title == null ? "" : title);
    }

    @Override
    public String getTooltipText() {
        String result = this.getElement().getProperty("title");
        return result == null ? "" : result;
    }

    @Override
    public void setLabelPosition(LabelPosition position) {
        WithLabelPositionableMixin.super.setLabelPosition(position);
        this.getElement().executeJs("this.shadowRoot.getElementById('input').setAttribute('data-label-position-details', '" + position.getPositionData() + "');", new Serializable[0]);
    }
}

