/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.numbers;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.events.text.TextSelectionEvent;
import org.vaadin.miki.events.text.TextSelectionListener;
import org.vaadin.miki.events.text.TextSelectionNotifier;
import org.vaadin.miki.markers.CanReceiveSelectionEventsFromClient;
import org.vaadin.miki.markers.CanSelectText;
import org.vaadin.miki.markers.WithClearButtonMixin;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithLocaleMixin;
import org.vaadin.miki.markers.WithNullValueOptionallyAllowedMixin;
import org.vaadin.miki.markers.WithPlaceholderMixin;
import org.vaadin.miki.markers.WithReceivingSelectionEventsFromClientMixin;
import org.vaadin.miki.markers.WithRequiredMixin;
import org.vaadin.miki.markers.WithTooltipMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.shared.labels.LabelPosition;
import org.vaadin.miki.superfields.text.SuperTextField;

@CssImport(value="./styles/form-layout-number-field-styles.css")
public abstract class AbstractSuperNumberField<T extends Number, SELF extends AbstractSuperNumberField<T, SELF>>
extends CustomField<T>
implements CanSelectText,
CanReceiveSelectionEventsFromClient,
WithReceivingSelectionEventsFromClientMixin<SELF>,
TextSelectionNotifier<SELF>,
HasPrefixAndSuffix,
HasValueChangeMode,
HasStyle,
WithLocaleMixin<SELF>,
WithLabelMixin<SELF>,
WithPlaceholderMixin<SELF>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T, SELF>,
WithIdMixin<SELF>,
WithNullValueOptionallyAllowedMixin<SELF, AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T>,
WithHelperMixin<SELF>,
WithHelperPositionableMixin<SELF>,
WithClearButtonMixin<SELF>,
WithRequiredMixin<SELF>,
WithLabelPositionableMixin<SELF>,
WithTooltipMixin<SELF> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSuperNumberField.class);
    private static final String TEXT_FIELD_STYLE_PREFIX = "belongs-to-";
    private static final String REGEXP_START_AT_LEAST_ONE_DIGIT = "\\d{1,";
    private static final String REGEXP_START_ANY_DIGITS = "\\d{0,";
    private static final char NON_BREAKING_SPACE = '\u00a0';
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private final SuperTextField field = new SuperTextField();
    private final SerializablePredicate<T> negativityPredicate;
    private final SerializableFunction<T, T> turnToPositiveOperator;
    private DecimalFormat format;
    private String regexp;
    private boolean autoselect;
    private boolean groupingSeparatorHiddenOnFocus;
    private boolean negativeValueAllowed = true;
    private boolean nullValueAllowed = false;
    private Locale locale;
    private boolean integerPartOptional = false;
    private boolean focused = false;
    private Registration innerFieldValueChangeRegistration;

    protected AbstractSuperNumberField(T defaultValue, SerializablePredicate<T> negativityPredicate, SerializableFunction<T, T> turnToPositiveOperator, String label, Locale locale, int maxFractionDigits) {
        super(defaultValue);
        this.negativityPredicate = negativityPredicate;
        this.turnToPositiveOperator = turnToPositiveOperator;
        if (defaultValue == null) {
            this.setNullValueAllowed(true);
        }
        this.locale = locale;
        this.format = this.getFormat(locale);
        if (maxFractionDigits >= 0) {
            this.format.setMaximumFractionDigits(maxFractionDigits);
        }
        this.updateRegularExpression();
        this.field.addClassName(TEXT_FIELD_STYLE_PREFIX + this.getClass().getSimpleName().toLowerCase());
        this.add(new Component[]{this.field});
        this.field.setLabel(label);
        this.field.setPreventInvalidInput(true);
        this.field.setWidthFull();
        this.field.addFocusListener(this::onFieldSelected);
        this.field.addBlurListener(this::onFieldBlurred);
        this.field.addTextSelectionListener(this::onTextSelected);
        this.listenToValueChangesFromInnerField();
    }

    private void listenToValueChangesFromInnerField() {
        if (this.innerFieldValueChangeRegistration == null) {
            this.innerFieldValueChangeRegistration = this.field.addValueChangeListener(this::onFieldChanged);
        }
    }

    private void ignoreValueChangesFromInnerField(Consumer<AbstractSuperNumberField<T, SELF>> consumer) {
        boolean restore;
        boolean bl = restore = this.innerFieldValueChangeRegistration != null;
        if (restore) {
            this.innerFieldValueChangeRegistration.remove();
        }
        this.innerFieldValueChangeRegistration = null;
        consumer.accept(this);
        if (restore) {
            this.listenToValueChangesFromInnerField();
        }
    }

    private void onFieldChanged(HasValue.ValueChangeEvent<String> event) {
        this.updateValue();
    }

    protected static String escapeDot(char character) {
        return character == '.' ? "\\." : String.valueOf(character);
    }

    private DecimalFormat getFormat(Locale locale) {
        return (DecimalFormat)NumberFormat.getInstance(Optional.ofNullable(locale).orElse(Locale.getDefault()));
    }

    @Override
    public void setLocale(Locale locale) {
        int maxFraction = this.format.getMaximumFractionDigits();
        int minFraction = this.format.getMinimumFractionDigits();
        int maxInteger = this.format.getMaximumIntegerDigits();
        DecimalFormat newFormat = this.getFormat(locale);
        newFormat.setMaximumFractionDigits(maxFraction);
        newFormat.setMinimumFractionDigits(minFraction);
        newFormat.setMaximumIntegerDigits(maxInteger);
        this.locale = locale;
        this.setDecimalFormat(newFormat);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setDecimalFormat(DecimalFormat format) {
        this.format = Optional.ofNullable(format).orElse((DecimalFormat)NumberFormat.getNumberInstance());
        this.updateRegularExpression();
    }

    protected boolean isIntegerPartOptional() {
        return this.integerPartOptional;
    }

    protected void setIntegerPartOptional(boolean optional) {
        this.integerPartOptional = optional;
        this.updateRegularExpression();
    }

    protected void setMinimumFractionDigits(int digits) {
        this.format.setMinimumFractionDigits(digits);
        this.updateRegularExpression(true);
    }

    protected void setMaximumFractionDigits(int digits) {
        this.format.setMaximumFractionDigits(digits);
        this.updateRegularExpression(true);
    }

    public void setMaximumIntegerDigits(int digits) {
        this.format.setMaximumIntegerDigits(digits);
        this.updateRegularExpression(true);
    }

    public final SELF withMaximumIntegerDigits(int digits) {
        this.setMaximumIntegerDigits(digits);
        return (SELF)this;
    }

    protected final void updateRegularExpression(boolean ignoreValueChangeFromField) {
        if (ignoreValueChangeFromField) {
            this.ignoreValueChangesFromInnerField(AbstractSuperNumberField::updateRegularExpression);
        } else {
            this.updateRegularExpression();
        }
    }

    protected final void updateRegularExpression() {
        Number value = (Number)this.getValue();
        this.regexp = this.buildRegularExpression(new StringBuilder(), this.format).toString();
        this.field.setPattern(this.regexp);
        LOGGER.debug("pattern updated to {}", (Object)this.regexp);
        if (!this.isNegativeValueAllowed() && value != null && this.negativityPredicate.test((Object)value)) {
            LOGGER.debug("negative values are not allowed, so turning into positive value {}", (Object)value);
            this.setValue(this.turnToPositiveOperator.apply((Object)value));
        } else {
            this.setPresentationValue((T)value);
        }
    }

    protected StringBuilder buildRegularExpression(StringBuilder builder, DecimalFormat format) {
        String groupSeparatorRegexp = format.getDecimalFormatSymbols().getGroupingSeparator() == '\u00a0' ? "[ " + format.getDecimalFormatSymbols().getGroupingSeparator() + "]" : AbstractSuperNumberField.escapeDot(format.getDecimalFormatSymbols().getGroupingSeparator());
        builder.append("^");
        if (this.isNegativeValueAllowed()) {
            builder.append(format.getDecimalFormatSymbols().getMinusSign()).append("?");
        }
        builder.append("(");
        String startingGroup = this.isIntegerPartOptional() ? REGEXP_START_ANY_DIGITS : REGEXP_START_AT_LEAST_ONE_DIGIT;
        int groupingSize = Math.max(1, format.getGroupingSize());
        int maxIntegerDigits = format.getMaximumIntegerDigits();
        if (maxIntegerDigits <= groupingSize) {
            builder.append(startingGroup).append(maxIntegerDigits).append("}");
        } else {
            int leftmostGroupMaxSize = maxIntegerDigits % groupingSize;
            int middleGroupCount = maxIntegerDigits / groupingSize - 1;
            if (leftmostGroupMaxSize == 0) {
                leftmostGroupMaxSize = groupingSize;
                --middleGroupCount;
            }
            if (middleGroupCount == 0) {
                builder.append(startingGroup).append(leftmostGroupMaxSize).append("}").append(groupSeparatorRegexp).append("?").append(REGEXP_START_ANY_DIGITS).append(groupingSize).append("}");
            } else {
                builder.append("(");
                builder.append("(");
                builder.append(startingGroup).append(leftmostGroupMaxSize).append("}");
                builder.append("(").append(groupSeparatorRegexp).append("?\\d{").append(groupingSize).append("}){0,").append(middleGroupCount).append("}");
                builder.append("(").append(groupSeparatorRegexp).append("?").append(REGEXP_START_ANY_DIGITS).append(groupingSize).append("}").append(")?");
                builder.append(")|(");
                builder.append(startingGroup).append(groupingSize).append("}");
                if (middleGroupCount > 1) {
                    builder.append("(").append(groupSeparatorRegexp).append("?\\d{").append(groupingSize).append("}){0,").append(middleGroupCount - 1).append("}");
                }
                builder.append("(").append(groupSeparatorRegexp).append("?").append(REGEXP_START_ANY_DIGITS).append(groupingSize).append("}").append(")?");
                builder.append(")");
                builder.append(")");
            }
        }
        if (this.format.getMaximumFractionDigits() > 0) {
            builder.append("(").append(AbstractSuperNumberField.escapeDot(format.getDecimalFormatSymbols().getDecimalSeparator())).append(REGEXP_START_ANY_DIGITS).append(format.getMaximumFractionDigits()).append("})?");
        }
        builder.append(")?$");
        return builder;
    }

    protected void updateFieldValue() {
        this.setPresentationValue((T)((Number)this.getValue()));
    }

    private void onFieldBlurred(BlurNotifier.BlurEvent<TextField> event) {
        this.focused = false;
        this.updateFieldValue();
        this.getEventBus().fireEvent((ComponentEvent)new BlurNotifier.BlurEvent((Component)this, event.isFromClient()));
    }

    private void onFieldSelected(FocusNotifier.FocusEvent<TextField> event) {
        this.focused = true;
        if (this.isGroupingSeparatorHiddenOnFocus()) {
            String withThousandsRemoved = this.field.getValue().replace(String.valueOf(this.format.getDecimalFormatSymbols().getGroupingSeparator()), "");
            LOGGER.debug("selected field with value {}, setting to {}", (Object)this.field.getValue(), (Object)withThousandsRemoved);
            this.field.setValue(withThousandsRemoved);
        }
        if (this.isAutoselect()) {
            this.field.selectAll();
        }
        this.getEventBus().fireEvent((ComponentEvent)new FocusNotifier.FocusEvent((Component)this, event.isFromClient()));
    }

    public String getRegexp() {
        return this.regexp;
    }

    protected final void setPresentationValue(T number) {
        if (number == null && !this.isNullValueAllowed()) {
            throw new IllegalArgumentException("null value is not allowed");
        }
        if (!this.isFocused()) {
            String formatted = number == null ? "" : this.format.format(number);
            LOGGER.debug("value {} to be presented as {} with {} decimal digits", new Object[]{number, formatted, this.format.getMaximumFractionDigits()});
            this.field.setValue(formatted);
            this.field.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this.field, (SerializableConsumer & Serializable)context -> this.field.getElement().setProperty("invalid", super.isInvalid())));
        }
    }

    protected abstract T parseRawValue(String var1, DecimalFormat var2) throws ParseException;

    protected T generateModelValue() {
        try {
            String fromEvent = this.field.getValue();
            T value = this.parseRawValue(fromEvent);
            LOGGER.debug("received raw value {}, matching? {} - parsed as {}", new Object[]{fromEvent, fromEvent.matches(this.regexp), value});
            return value;
        }
        catch (NullPointerException | ParseException e) {
            return (T)((Number)this.getEmptyValue());
        }
    }

    public boolean isAutoselect() {
        return this.autoselect;
    }

    public void setAutoselect(boolean autoselect) {
        this.autoselect = autoselect;
    }

    public final SELF withAutoselect(boolean autoselect) {
        this.setAutoselect(autoselect);
        return (SELF)this;
    }

    public boolean isGroupingSeparatorHiddenOnFocus() {
        return this.groupingSeparatorHiddenOnFocus;
    }

    public void setGroupingSeparatorHiddenOnFocus(boolean groupingSeparatorHiddenOnFocus) {
        this.groupingSeparatorHiddenOnFocus = groupingSeparatorHiddenOnFocus;
    }

    public final SELF withGroupingSeparatorHiddenOnFocus(boolean groupingSeparatorHiddenOnFocus) {
        this.setGroupingSeparatorHiddenOnFocus(groupingSeparatorHiddenOnFocus);
        return (SELF)this;
    }

    public boolean isNegativeValueAllowed() {
        return this.negativeValueAllowed;
    }

    public void setNegativeValueAllowed(boolean negativeValueAllowed) {
        this.negativeValueAllowed = negativeValueAllowed;
        this.updateRegularExpression();
    }

    public final SELF withNegativeValueAllowed(boolean negativeValueAllowed) {
        this.setNegativeValueAllowed(negativeValueAllowed);
        return (SELF)this;
    }

    public void setPrefixComponent(Component component) {
        this.field.setPrefixComponent(component);
    }

    public Component getPrefixComponent() {
        return this.field.getPrefixComponent();
    }

    public void setSuffixComponent(Component component) {
        this.field.setSuffixComponent(component);
    }

    public Component getSuffixComponent() {
        return this.field.getSuffixComponent();
    }

    public void setLabel(String label) {
        this.field.setLabel(label);
    }

    public String getLabel() {
        return this.field.getLabel();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        this.field.setPlaceholder(placeholder);
    }

    @Override
    public String getPlaceholder() {
        return this.field.getPlaceholder();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.field.setId(id == null ? null : TEXT_FIELD_STYLE_PREFIX + id);
    }

    public String getRawValue() {
        return this.field.getValue();
    }

    public void addThemeVariants(TextFieldVariant ... variants) {
        this.field.addThemeVariants(variants);
    }

    public void removeThemeVariants(TextFieldVariant ... variants) {
        this.field.removeThemeVariants(variants);
    }

    public void setReadOnly(boolean readOnly) {
        this.field.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.field.isReadOnly();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        this.field.setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    public boolean isRequiredIndicatorVisible() {
        return this.field.isRequiredIndicatorVisible();
    }

    public void setErrorMessage(String errorMessage) {
        this.field.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.field.getErrorMessage();
    }

    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
        this.field.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.field.isInvalid();
    }

    @Override
    public void select(int from, int to) {
        this.field.select(from, to);
    }

    @Override
    public void selectAll() {
        this.field.selectAll();
    }

    @Override
    public void selectNone() {
        this.field.selectNone();
    }

    private void onTextSelected(TextSelectionEvent<SuperTextField> event) {
        TextSelectionEvent<AbstractSuperNumberField> selfEvent = new TextSelectionEvent<AbstractSuperNumberField>(this, event.isFromClient(), event.getSelectionStart(), event.getSelectionEnd(), event.getSelectedText());
        this.getEventBus().fireEvent(selfEvent);
    }

    @Override
    public void setReceivingSelectionEventsFromClient(boolean receivingSelectionEventsFromClient) {
        this.field.setReceivingSelectionEventsFromClient(receivingSelectionEventsFromClient);
    }

    @Override
    public boolean isReceivingSelectionEventsFromClient() {
        return this.field.isReceivingSelectionEventsFromClient();
    }

    @Override
    public Registration addTextSelectionListener(TextSelectionListener<SELF> listener) {
        return this.getEventBus().addListener(TextSelectionEvent.class, listener);
    }

    @Override
    public SELF withReceivingSelectionEventsFromClient(boolean receivingSelectionEventsFromClient) {
        this.setReceivingSelectionEventsFromClient(receivingSelectionEventsFromClient);
        return (SELF)this;
    }

    @Override
    public final void setNullValueAllowed(boolean allowingNullValue) {
        this.nullValueAllowed = allowingNullValue;
        if (!allowingNullValue && this.getRawValue().isEmpty()) {
            this.setValue(this.getEmptyValue());
        }
    }

    @Override
    public boolean isNullValueAllowed() {
        return this.nullValueAllowed;
    }

    public void setHelperComponent(Component component) {
        this.field.setHelperComponent(component);
    }

    public void setHelperText(String helperText) {
        this.field.setHelperText(helperText);
    }

    public Component getHelperComponent() {
        return this.field.getHelperComponent();
    }

    public String getHelperText() {
        return this.field.getHelperText();
    }

    @Override
    public void setHelperAbove() {
        this.field.setHelperAbove();
    }

    @Override
    public void setHelperBelow() {
        this.field.setHelperBelow();
    }

    @Override
    public void setHelperAbove(boolean above) {
        this.field.setHelperAbove(above);
    }

    @Override
    public boolean isHelperAbove() {
        return this.field.isHelperAbove();
    }

    @Override
    public void setTooltipText(String text) {
        this.field.setTooltipText(text);
    }

    @Override
    public String getTooltipText() {
        return this.field.getTooltipText();
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.field.setValueChangeMode(valueChangeMode);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.field.getValueChangeMode();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.field.setValueChangeTimeout(valueChangeTimeout);
    }

    public int getValueChangeTimeout() {
        return this.field.getValueChangeTimeout();
    }

    protected final boolean isFocused() {
        return this.focused;
    }

    public void focus() {
        this.field.focus();
    }

    public void blur() {
        this.field.blur();
    }

    @Override
    public void setClearButtonVisible(boolean state) {
        this.field.setClearButtonVisible(state);
    }

    @Override
    public boolean isClearButtonVisible() {
        return this.field.isClearButtonVisible();
    }

    @Override
    public void setRequired(boolean required) {
        this.field.setRequired(required);
    }

    @Override
    public boolean isRequired() {
        return this.field.isRequired();
    }

    @Override
    public void setLabelPosition(LabelPosition position) {
        this.field.setLabelPosition(position);
    }

    @Override
    public LabelPosition getLabelPosition() {
        return this.field.getLabelPosition();
    }

    final void simulateFocus() {
        this.onFieldSelected((FocusNotifier.FocusEvent<TextField>)new FocusNotifier.FocusEvent((Component)this.field, false));
    }

    final void simulateBlur() {
        this.onFieldBlurred((BlurNotifier.BlurEvent<TextField>)new BlurNotifier.BlurEvent((Component)this.field, false));
    }

    final int getMaximumFractionDigits() {
        return this.format.getMaximumFractionDigits();
    }

    final int getMinimumFractionDigits() {
        return this.format.getMinimumFractionDigits();
    }

    final int getMaximumIntegerDigits() {
        return this.format.getMaximumIntegerDigits();
    }

    final T parseRawValue(String rawValue) throws ParseException {
        if (rawValue == null) {
            rawValue = "";
        }
        if (rawValue.isEmpty()) {
            if (this.isNullValueAllowed()) {
                return null;
            }
            return (T)((Number)this.getEmptyValue());
        }
        if (this.format.getDecimalFormatSymbols().getGroupingSeparator() == '\u00a0') {
            rawValue = rawValue.replace(' ', '\u00a0');
        }
        return this.parseRawValue(rawValue, this.format);
    }
}

