/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.unload;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import java.io.Serializable;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.superfields.unload.UnloadEvent;
import org.vaadin.miki.superfields.unload.UnloadListener;

@JsModule(value="./unload-observer.js")
@Tag(value="unload-observer")
public class UnloadObserver
extends PolymerTemplate<TemplateModel>
implements WithIdMixin<UnloadObserver> {
    private boolean queryingOnUnload;
    private boolean clientInitialised;

    public static UnloadObserver get() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("there is no UI available to create UnloadObserver for");
        }
        return UnloadObserver.get(ui);
    }

    public static UnloadObserver get(UI ui) {
        UnloadObserver instance = (UnloadObserver)ComponentUtil.getData((Component)ui, UnloadObserver.class);
        if (instance == null) {
            instance = new UnloadObserver();
            ComponentUtil.setData((Component)ui, UnloadObserver.class, (Object)instance);
        }
        return instance;
    }

    public static UnloadObserver getAttached() {
        return UnloadObserver.getAttached(UI.getCurrent());
    }

    public static <C extends Component> UnloadObserver getAttached(C parent) {
        if (parent == null) {
            throw new NullPointerException("parent component to attach UnloadObserver to must not be null");
        }
        if (!parent.getUI().isPresent()) {
            throw new IllegalArgumentException("parent component is not attached to any UI, hence UnloadObserver cannot be added to it");
        }
        UnloadObserver observer = UnloadObserver.get((UI)parent.getUI().get());
        if (observer.getParent().isPresent()) {
            Component currentParent = (Component)observer.getParent().get();
            if (currentParent != parent) {
                if (!(currentParent instanceof HasComponents)) {
                    throw new IllegalStateException("UnloadObserver is currently attached to " + currentParent.getClass().getName() + " which is not HasComponents and cannot be automatically removed");
                }
                ((HasComponents)currentParent).remove(new Component[]{observer});
                ((HasComponents)parent).add(new Component[]{observer});
            }
        } else {
            ((HasComponents)parent).add(new Component[]{observer});
        }
        return observer;
    }

    private UnloadObserver() {
        this(true);
    }

    private UnloadObserver(boolean queryOnUnload) {
        this.setQueryingOnUnload(queryOnUnload);
    }

    public void setQueryingOnUnload(boolean queryingOnUnload) {
        if (queryingOnUnload != this.queryingOnUnload) {
            this.queryingOnUnload = queryingOnUnload;
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.getElement().callJsFunction("queryOnUnload", new Serializable[]{Boolean.valueOf(this.queryingOnUnload)})));
        }
    }

    public boolean isQueryingOnUnload() {
        return this.queryingOnUnload;
    }

    public UnloadObserver withQueryingOnUnload(boolean value) {
        this.setQueryingOnUnload(value);
        return this;
    }

    public UnloadObserver withQueryingOnUnload() {
        return this.withQueryingOnUnload(true);
    }

    public UnloadObserver withoutQueryingOnUnload() {
        return this.withQueryingOnUnload(false);
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (!this.clientInitialised) {
            this.getElement().callJsFunction("initObserver", new Serializable[0]);
            this.clientInitialised = true;
        }
        super.onAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.clientInitialised = false;
        detachEvent.getUI().getPage().executeJs("if (window.Vaadin.unloadObserver.attemptHandler !== undefined) {    window.removeEventListener('beforeunload', window.Vaadin.unloadObserver.attemptHandler);}", new Serializable[0]);
        super.onDetach(detachEvent);
    }

    @ClientCallable
    private void unloadHappened() {
        this.fireUnloadEvent(new UnloadEvent(this, false));
    }

    @ClientCallable
    private void unloadAttempted() {
        this.fireUnloadEvent(new UnloadEvent(this, true));
    }

    protected void fireUnloadEvent(UnloadEvent event) {
        this.getEventBus().fireEvent((ComponentEvent)event);
    }

    public Registration addUnloadListener(UnloadListener listener) {
        return this.getEventBus().addListener(UnloadEvent.class, (ComponentEventListener)listener);
    }
}

