/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.util;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.vaadin.miki.markers.HasIndex;
import org.vaadin.miki.superfields.buttons.IndexedButton;
import org.vaadin.miki.superfields.collections.CollectionComponentProvider;
import org.vaadin.miki.superfields.collections.CollectionController;
import org.vaadin.miki.superfields.collections.CollectionLayoutProvider;
import org.vaadin.miki.superfields.collections.CollectionValueComponentProvider;
import org.vaadin.miki.superfields.collections.MapEntryField;
import org.vaadin.miki.superfields.layouts.FlexLayoutHelpers;
import org.vaadin.miki.superfields.layouts.HeaderFooterFieldWrapper;
import org.vaadin.miki.superfields.layouts.HeaderFooterLayoutWrapper;
import org.vaadin.miki.superfields.text.SuperTextArea;
import org.vaadin.miki.superfields.text.SuperTextField;

public class CollectionComponentProviders {
    public static SuperTextField textField(int index, CollectionController controller) {
        return new SuperTextField();
    }

    public static SuperTextArea textArea(int index, CollectionController controller) {
        return new SuperTextArea();
    }

    public static <T, F extends Component & HasLabel> CollectionValueComponentProvider<T, F> labelledField(Supplier<F> fieldSupplier, String label) {
        return (index, controller) -> {
            Component result = (Component)fieldSupplier.get();
            ((HasLabel)result).setLabel(String.format(label, index));
            return result;
        };
    }

    public static <T, F extends Component> CollectionValueComponentProvider<T, HeaderFooterFieldWrapper<T, FlexLayout, FlexLayout>> row(CollectionValueComponentProvider<T, F> inner, Collection<CollectionComponentProvider<?>> headerComponents, Collection<CollectionComponentProvider<?>> footerComponents) {
        return (index, controller) -> (HeaderFooterFieldWrapper)((HeaderFooterFieldWrapper)new HeaderFooterFieldWrapper(FlexLayoutHelpers::row, FlexLayoutHelpers.column(), inner.provideComponent(index, controller), FlexLayoutHelpers.column()).withHeaderComponents((Component[])headerComponents.stream().map(f -> f.provideComponent(index, controller)).toArray(Component[]::new))).withFooterComponents((Component[])footerComponents.stream().map(f -> f.provideComponent(index, controller)).toArray(Component[]::new));
    }

    public static <T, F extends Component> CollectionValueComponentProvider<T, HeaderFooterFieldWrapper<T, FlexLayout, FlexLayout>> rowWithRemoveButtonLast(CollectionValueComponentProvider<T, F> inner, String removeButtonText) {
        return CollectionComponentProviders.row(inner, Collections.emptyList(), Collections.singleton((index, controller) -> new IndexedButton(removeButtonText, index, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> controller.remove(((HasIndex)event.getSource()).getIndex()))));
    }

    public static <T, F extends Component> CollectionValueComponentProvider<T, HeaderFooterFieldWrapper<T, FlexLayout, FlexLayout>> rowWithRemoveButtonFirst(CollectionValueComponentProvider<T, F> inner, String removeButtonText) {
        return CollectionComponentProviders.row(inner, Collections.singleton(CollectionComponentProviders.removeButton(removeButtonText)), Collections.emptyList());
    }

    public static <T, F extends Component> CollectionValueComponentProvider<T, HeaderFooterFieldWrapper<T, FlexLayout, FlexLayout>> columnWithHeaderAndFooterRows(CollectionValueComponentProvider<T, F> inner, Collection<CollectionComponentProvider<?>> headerComponents, Collection<CollectionComponentProvider<?>> footerComponents) {
        return (index, controller) -> (HeaderFooterFieldWrapper)((HeaderFooterFieldWrapper)new HeaderFooterFieldWrapper(FlexLayoutHelpers::column, FlexLayoutHelpers.row(), inner.provideComponent(index, controller), FlexLayoutHelpers.row()).withHeaderComponents((Component[])headerComponents.stream().map(f -> f.provideComponent(index, controller)).toArray(Component[]::new))).withFooterComponents((Component[])footerComponents.stream().map(h -> h.provideComponent(index, controller)).toArray(Component[]::new));
    }

    public static CollectionLayoutProvider<HeaderFooterLayoutWrapper<FlexLayout, FlexLayout, FlexLayout, FlexLayout>> columnWithHeaderAndFooterRows(Collection<CollectionComponentProvider<?>> headerComponents, Collection<CollectionComponentProvider<?>> footerComponents) {
        return (index, controller) -> (HeaderFooterLayoutWrapper)((HeaderFooterLayoutWrapper)FlexLayoutHelpers.columnWithHeaderRowAndFooterRow().withHeaderComponents((Component[])headerComponents.stream().map(h -> h.provideComponent(index, controller)).toArray(Component[]::new))).withFooterComponents((Component[])footerComponents.stream().map(f -> f.provideComponent(index, controller)).toArray(Component[]::new));
    }

    public static CollectionComponentProvider<Button> removeAllButton(String text) {
        return (index, controller) -> new Button(text, (ComponentEventListener & Serializable)event -> controller.removeAll());
    }

    public static CollectionComponentProvider<Button> addFirstButton(String text) {
        return (index, controller) -> new Button(text, (ComponentEventListener & Serializable)event -> controller.add(0));
    }

    public static CollectionComponentProvider<Button> addLastButton(String text) {
        return (index, controller) -> new Button(text, (ComponentEventListener & Serializable)event -> controller.add());
    }

    public static CollectionComponentProvider<IndexedButton> removeButton(String text) {
        return (index, controller) -> new IndexedButton(text, index, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> controller.remove(((HasIndex)event.getSource()).getIndex()));
    }

    public static <K, V, C extends Component, W extends Component> CollectionValueComponentProvider<Map.Entry<K, V>, MapEntryField<K, V>> mapEntryField(SerializableSupplier<C> keyComponentSupplier, SerializableSupplier<W> valueComponentSupplier) {
        return (index, controller) -> new MapEntryField(keyComponentSupplier, valueComponentSupplier);
    }

    public static <K, V, C extends Component & HasValue<?, K>, W extends Component & HasValue<?, V>> CollectionValueComponentProvider<Map.Entry<K, V>, MapEntryField<K, V>> mapEntryField(String keyLabel, SerializableSupplier<C> keyComponentSupplier, String valueLabel, SerializableSupplier<W> valueComponentSupplier) {
        return (index, controller) -> new MapEntryField((SerializableSupplier & Serializable)() -> {
            Component result = (Component)keyComponentSupplier.get();
            ((HasLabel)result).setLabel(keyLabel);
            return result;
        }, (SerializableSupplier & Serializable)() -> {
            Component result = (Component)valueComponentSupplier.get();
            ((HasLabel)result).setLabel(valueLabel);
            return result;
        });
    }

    private CollectionComponentProviders() {
    }
}

