/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ReflectTools {
    public static final int GETTER_INDEX = 0;
    public static final int SETTER_INDEX = 1;

    public static <V> Optional<V> getValueOfField(Object instance, Class<? extends V> valueType, String fieldName) {
        Class<?> typeToCheck = instance.getClass();
        Field field = null;
        while (typeToCheck != null) {
            try {
                field = typeToCheck.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                typeToCheck = typeToCheck.getSuperclass();
            }
            if (field == null || !valueType.isAssignableFrom(field.getType())) continue;
            typeToCheck = null;
        }
        if (field != null) {
            try {
                field.setAccessible(true);
                return Optional.ofNullable(valueType.cast(field.get(instance)));
            }
            catch (ClassCastException | IllegalAccessException exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static Optional<Method> findGetter(Field field, Class<?> type) {
        String[] stringArray;
        if (Objects.equals(Boolean.TYPE, field.getType()) || Objects.equals(Boolean.class, field.getType())) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "is";
            stringArray2[1] = "get";
            stringArray = stringArray2;
            stringArray2[2] = "are";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "get";
        }
        for (String prefix : stringArray) {
            try {
                Method method = type.getMethod(prefix + field.getName().substring(0, 1).toUpperCase(Locale.ROOT) + field.getName().substring(1), new Class[0]);
                if (!method.getReturnType().isAssignableFrom(field.getType()) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                return Optional.of(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static Optional<Method> findSetter(Field field, Class<?> type) {
        String setterName = "set" + field.getName().substring(0, 1).toUpperCase(Locale.ROOT) + field.getName().substring(1);
        for (Method method : type.getMethods()) {
            if (!setterName.equals(method.getName()) || method.getParameterCount() != 1 || !field.getType().isAssignableFrom(method.getParameterTypes()[0]) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public static Map<Field, Method[]> extractFieldsWithMethods(Class<?> type, boolean ignoreSuperclasses) {
        HashMap<Field, Method[]> result = new HashMap<Field, Method[]>();
        if (type != null) {
            Class<Object> toScan = type;
            while (toScan != null && !Objects.equals(toScan, Object.class)) {
                for (Field declaredField : toScan.getDeclaredFields()) {
                    result.putIfAbsent(declaredField, new Method[2]);
                }
                toScan = ignoreSuperclasses ? Object.class : toScan.getSuperclass();
            }
            HashSet fieldsWithoutAccessors = new HashSet();
            result.forEach((field, methods) -> {
                ReflectTools.findGetter(field, type).ifPresent(method -> {
                    methods[0] = method;
                });
                ReflectTools.findSetter(field, type).ifPresent(method -> {
                    methods[1] = method;
                });
                if (methods[0] == null && methods[1] == null) {
                    fieldsWithoutAccessors.add(field);
                }
            });
            fieldsWithoutAccessors.forEach(result::remove);
        }
        return result;
    }

    public static Optional<Class<?>> extractGenericType(Field field, int genericIndex) {
        if (field.getGenericType() instanceof ParameterizedType) {
            Type[] params = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            return genericIndex < 0 || genericIndex >= params.length ? Optional.empty() : Optional.of((Class)params[genericIndex]);
        }
        return Optional.empty();
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("cannot create an instance of " + type.getName(), e);
        }
    }

    private ReflectTools() {
    }
}

