/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.buttons;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public interface ButtonState
extends Serializable {
    public String getText();

    public Component getIcon();

    public Set<String> getClassNames();

    public Set<String> getThemeNames();

    public Set<ButtonVariant> getThemeVariants();

    public static ButtonState of(Button button) {
        final String text = button.getText();
        final Component icon = button.getIcon();
        final Set classes = Collections.unmodifiableSet(button.getClassNames());
        final Set themes = Collections.unmodifiableSet(button.getThemeNames());
        return new ButtonState(){

            @Override
            public String getText() {
                return text;
            }

            @Override
            public Component getIcon() {
                return icon;
            }

            @Override
            public Set<String> getClassNames() {
                return classes;
            }

            @Override
            public Set<String> getThemeNames() {
                return themes;
            }

            @Override
            public Set<ButtonVariant> getThemeVariants() {
                return Collections.emptySet();
            }
        };
    }
}

