/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.dates;

import com.vaadin.flow.component.datepicker.DatePicker;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.markers.HasLocale;

public final class SuperDatePickerI18n
extends DatePicker.DatePickerI18n
implements HasLocale {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuperDatePickerI18n.class);
    private static final String RESOURCE_BUNDLE_NAME = SuperDatePickerI18n.class.getSimpleName().toLowerCase();
    private static final String FORMAT_WARNING_MESSAGE = "this component has its own format setting method, please use it instead or switch to a framework component (DatePicker / DateTimePicker)";
    private final Map<String, Function<String, DatePicker.DatePickerI18n>> keysToStringMethods = new HashMap<String, Function<String, DatePicker.DatePickerI18n>>();
    private final Map<String, Function<List<String>, DatePicker.DatePickerI18n>> keysToListStringMethods = new HashMap<String, Function<List<String>, DatePicker.DatePickerI18n>>();
    private final List<String> displayMonthNames = new ArrayList<String>();
    private Locale locale;

    public SuperDatePickerI18n() {
        this(Locale.getDefault());
    }

    public SuperDatePickerI18n(Locale locale) {
        this.keysToStringMethods.put("calendar", arg_0 -> ((SuperDatePickerI18n)this).setCalendar(arg_0));
        this.keysToStringMethods.put("cancel", arg_0 -> ((SuperDatePickerI18n)this).setCancel(arg_0));
        this.keysToStringMethods.put("clear", arg_0 -> ((SuperDatePickerI18n)this).setClear(arg_0));
        this.keysToStringMethods.put("today", arg_0 -> ((SuperDatePickerI18n)this).setToday(arg_0));
        this.keysToStringMethods.put("week", arg_0 -> ((SuperDatePickerI18n)this).setWeek(arg_0));
        this.keysToListStringMethods.put("month-names", arg_0 -> ((SuperDatePickerI18n)this).setMonthNames(arg_0));
        this.keysToListStringMethods.put("weekdays", arg_0 -> ((SuperDatePickerI18n)this).setWeekdays(arg_0));
        this.keysToListStringMethods.put("weekdays-short", arg_0 -> ((SuperDatePickerI18n)this).setWeekdaysShort(arg_0));
        this.keysToListStringMethods.put("display-month-names", this::setDisplayMonthNames);
        this.setLocale(locale);
    }

    public DatePicker.DatePickerI18n setDisplayMonthNames(List<String> displayMonthNames) {
        this.displayMonthNames.clear();
        this.displayMonthNames.addAll(displayMonthNames == null || displayMonthNames.isEmpty() ? this.getMonthNames() : displayMonthNames);
        return this;
    }

    public List<String> getDisplayMonthNames() {
        return Collections.unmodifiableList(this.displayMonthNames.isEmpty() ? this.getMonthNames() : this.displayMonthNames);
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        this.setMonthNames(Arrays.asList(symbols.getMonths()).subList(0, 12));
        this.setDisplayMonthNames(Arrays.asList(symbols.getMonths()).subList(0, 12));
        this.setFirstDayOfWeek(Calendar.getInstance(this.locale).getFirstDayOfWeek() == 2 ? 1 : 0);
        this.setWeekdays(Arrays.stream(symbols.getWeekdays()).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
        this.setWeekdaysShort(Arrays.stream(symbols.getShortWeekdays()).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, this.locale);
            if (!Objects.equals(bundle.getLocale().getLanguage(), this.locale.getLanguage())) {
                throw new MissingResourceException(RESOURCE_BUNDLE_NAME, this.getClass().getName(), null);
            }
            Set<String> bundleKeys = bundle.keySet();
            this.keysToStringMethods.entrySet().stream().filter(entry -> bundleKeys.contains(entry.getKey())).forEach(entry -> ((Function)entry.getValue()).apply(bundle.getString((String)entry.getKey())));
            this.keysToListStringMethods.entrySet().stream().filter(entry -> bundleKeys.contains(entry.getKey())).forEach(entry -> ((Function)entry.getValue()).apply(Arrays.stream(bundle.getString((String)entry.getKey()).split(",")).map(String::trim).collect(Collectors.toList())));
            if (bundleKeys.contains("first-day-of-week")) {
                this.setFirstDayOfWeek(Integer.parseInt(bundle.getString("first-day-of-week")));
            }
            LOGGER.info("these properties were overwritten by resource bundle: {}", bundleKeys);
        }
        catch (MissingResourceException mre) {
            LOGGER.warn("resource bundle {} for locale {} not found, some texts may display incorrectly or not at all", (Object)RESOURCE_BUNDLE_NAME, (Object)locale);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public DatePicker.DatePickerI18n setDateFormat(String dateFormat) {
        LOGGER.warn(FORMAT_WARNING_MESSAGE);
        return super.setDateFormat(dateFormat);
    }

    public DatePicker.DatePickerI18n setDateFormats(String primaryFormat, String ... additionalParsingFormats) {
        LOGGER.warn(FORMAT_WARNING_MESSAGE);
        return super.setDateFormats(primaryFormat, additionalParsingFormats);
    }
}

