/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.object.builder;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.function.SerializableSupplier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.superfields.object.Property;
import org.vaadin.miki.superfields.object.PropertyComponentBuilder;
import org.vaadin.miki.superfields.object.builder.FieldBuilder;
import org.vaadin.miki.superfields.text.LabelField;
import org.vaadin.miki.util.StringTools;

public class SimplePropertyComponentBuilder
implements PropertyComponentBuilder {
    public static final FieldBuilder<?> DEFAULT_BUILDER = property -> new LabelField();
    private final Map<Predicate<Property<?, ?>>, FieldBuilder<?>> registeredBuilders = new LinkedHashMap();
    private FieldBuilder<?> defaultBuilder = DEFAULT_BUILDER;
    private boolean defaultLabel = true;

    public static Predicate<Property<?, ?>> isExactlyType(Class<?> type) {
        return def -> Objects.equals(type, def.getType());
    }

    public static Predicate<Property<?, ?>> isOfType(Class<?> type) {
        return def -> type.isAssignableFrom(def.getType());
    }

    @Override
    public <P, C extends Component> Optional<C> buildPropertyField(Property<?, P> property) {
        FieldBuilder<?> fieldBuilder = this.registeredBuilders.keySet().stream().filter(predicate -> predicate.test(property)).findFirst().map(this.registeredBuilders::get).map(builder -> builder).orElse(this.defaultBuilder);
        Component result = (Component)fieldBuilder.buildPropertyField(property);
        if (result instanceof HasLabel && this.isDefaultLabel()) {
            String fieldLabel = StringTools.humanReadable(property.getName());
            ((HasLabel)result).setLabel(fieldLabel);
            LoggerFactory.getLogger(this.getClass()).info("default label for {} ({}): {}", new Object[]{property.getName(), result.getClass().getSimpleName(), fieldLabel});
        }
        return Optional.ofNullable(result);
    }

    public Map<Predicate<Property<?, ?>>, FieldBuilder<?>> getRegisteredBuilders() {
        return this.registeredBuilders;
    }

    public <P, C extends Component> void registerType(Class<P> valueType, SerializableSupplier<C> componentSupplier) {
        this.registerBuilder(SimplePropertyComponentBuilder.isExactlyType(valueType), (Property<?, P> def) -> (HasValue)componentSupplier.get());
    }

    public final <P, C extends Component> SimplePropertyComponentBuilder withRegisteredType(Class<P> valueType, SerializableSupplier<C> componentSupplier) {
        this.registerType(valueType, componentSupplier);
        return this;
    }

    public <P> void registerBuilder(Class<P> valueType, FieldBuilder<P> builder) {
        this.registerBuilder(SimplePropertyComponentBuilder.isOfType(valueType), builder);
    }

    public <P> void registerBuilder(Predicate<Property<?, P>> predicate, FieldBuilder<P> builder) {
        this.registeredBuilders.put(predicate, builder);
    }

    public final <P> SimplePropertyComponentBuilder withRegisteredBuilder(Class<P> valueType, FieldBuilder<P> builder) {
        this.registerBuilder(valueType, builder);
        return this;
    }

    public final <P> SimplePropertyComponentBuilder withRegisteredBuilder(Predicate<Property<?, P>> predicate, FieldBuilder<P> builder) {
        this.registerBuilder(predicate, builder);
        return this;
    }

    public boolean isDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(boolean defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public final SimplePropertyComponentBuilder withDefaultLabel() {
        return this.withDefaultLabel(true);
    }

    public final SimplePropertyComponentBuilder withoutDefaultLabel() {
        return this.withDefaultLabel(false);
    }

    public final SimplePropertyComponentBuilder withDefaultLabel(boolean state) {
        this.setDefaultLabel(state);
        return this;
    }

    public void setDefaultBuilder(FieldBuilder<?> defaultBuilder) {
        this.defaultBuilder = Objects.requireNonNullElse(defaultBuilder, DEFAULT_BUILDER);
    }

    public final FieldBuilder<?> getDefaultBuilder() {
        return this.defaultBuilder;
    }

    public final SimplePropertyComponentBuilder withDefaultBuilder(FieldBuilder<?> builder) {
        this.setDefaultBuilder(builder);
        return this;
    }
}

