/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.object.reflect;

import com.vaadin.flow.function.SerializableFunction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.miki.superfields.object.PropertyMetadata;
import org.vaadin.miki.superfields.object.reflect.MetadataProvider;

public class AnnotationMetadataProvider
implements MetadataProvider {
    private final Map<Class<? extends Annotation>, Function<Annotation, PropertyMetadata>> registeredAnnotations = new HashMap<Class<? extends Annotation>, Function<Annotation, PropertyMetadata>>();

    @Override
    public Collection<PropertyMetadata> getMetadata(String name, Field field, Method setter, Method getter) {
        return Stream.of(field, setter, getter).filter(x$0 -> Objects.nonNull(x$0)).map(obj -> (PropertyMetadata[])this.registeredAnnotations.keySet().stream().map(type -> {
            Object annotation = obj.getAnnotation(type);
            if (annotation == null) {
                return null;
            }
            return this.registeredAnnotations.get(type).apply((Annotation)annotation);
        }).toArray(PropertyMetadata[]::new)).flatMap(Stream::of).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public <V, A extends Annotation> void registerAnnotation(String name, Class<V> type, Class<A> annotation, SerializableFunction<A, V> valueFunction) {
        this.registeredAnnotations.put(annotation, a -> new PropertyMetadata(name, type, valueFunction.apply((Object)((Annotation)annotation.cast(a)))));
    }

    public final <V, A extends Annotation> AnnotationMetadataProvider withRegisteredAnnotation(String name, Class<A> annotation, Class<V> type, SerializableFunction<A, V> valueFunction) {
        this.registerAnnotation(name, type, annotation, valueFunction);
        return this;
    }

    public void registerAnnotation(String name, Class<? extends Annotation> annotation) {
        this.registeredAnnotations.put(annotation, a -> new PropertyMetadata(name, Boolean.TYPE, true));
    }

    public final AnnotationMetadataProvider withRegisteredAnnotation(String name, Class<? extends Annotation> annotation) {
        this.registerAnnotation(name, annotation);
        return this;
    }
}

