/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.util.factory;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.superfields.checkbox.SuperCheckbox;
import org.vaadin.miki.superfields.collections.CollectionController;
import org.vaadin.miki.superfields.collections.CollectionField;
import org.vaadin.miki.superfields.collections.CollectionLayoutProvider;
import org.vaadin.miki.superfields.collections.CollectionValueComponentProvider;
import org.vaadin.miki.superfields.collections.MapEntryField;
import org.vaadin.miki.superfields.collections.MapField;
import org.vaadin.miki.superfields.dates.SuperDatePicker;
import org.vaadin.miki.superfields.dates.SuperDateTimePicker;
import org.vaadin.miki.superfields.layouts.FlexLayoutHelpers;
import org.vaadin.miki.superfields.numbers.SuperBigDecimalField;
import org.vaadin.miki.superfields.numbers.SuperDoubleField;
import org.vaadin.miki.superfields.numbers.SuperIntegerField;
import org.vaadin.miki.superfields.numbers.SuperLongField;
import org.vaadin.miki.superfields.object.ComponentConfigurator;
import org.vaadin.miki.superfields.object.ComponentGroupConfigurator;
import org.vaadin.miki.superfields.object.ObjectField;
import org.vaadin.miki.superfields.object.Property;
import org.vaadin.miki.superfields.object.PropertyComponentBuilder;
import org.vaadin.miki.superfields.object.PropertyGroupLayoutProvider;
import org.vaadin.miki.superfields.object.PropertyGroupingProvider;
import org.vaadin.miki.superfields.object.PropertyMetadata;
import org.vaadin.miki.superfields.object.PropertyProvider;
import org.vaadin.miki.superfields.object.builder.FieldBuilder;
import org.vaadin.miki.superfields.object.builder.SimplePropertyComponentBuilder;
import org.vaadin.miki.superfields.object.reflect.AnnotationMetadataProvider;
import org.vaadin.miki.superfields.object.reflect.ReflectivePropertyProvider;
import org.vaadin.miki.superfields.object.util.MetadataBasedGroupingProvider;
import org.vaadin.miki.superfields.text.LabelField;
import org.vaadin.miki.superfields.text.SuperTextArea;
import org.vaadin.miki.superfields.text.SuperTextField;
import org.vaadin.miki.superfields.util.factory.BigField;
import org.vaadin.miki.superfields.util.factory.BuildFieldWith;
import org.vaadin.miki.superfields.util.factory.ComponentId;
import org.vaadin.miki.superfields.util.factory.ComponentStyle;
import org.vaadin.miki.superfields.util.factory.FieldCaption;
import org.vaadin.miki.superfields.util.factory.FieldGroup;
import org.vaadin.miki.superfields.util.factory.FieldOrder;
import org.vaadin.miki.superfields.util.factory.ShowFieldAs;
import org.vaadin.miki.util.ReflectTools;
import org.vaadin.miki.util.StringTools;

public class ObjectFieldFactory {
    private static final Set<Class<?>> EXPECTED_BOOLEAN_TYPES = Set.of(Boolean.class, Boolean.TYPE);
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectFieldFactory.class);
    private static final Map<Class<?>, SerializableSupplier<?>> REFERENCE_COLLECTION_TYPES = Map.of(List.class, ArrayList::new, Set.class, LinkedHashSet::new);
    private CollectionLayoutProvider<?> collectionFieldLayoutProvider = (index, controller) -> FlexLayoutHelpers.column();
    private CollectionLayoutProvider<?> mapFieldLayoutProvider = (index, controller) -> FlexLayoutHelpers.column();
    private SerializableSupplier<? extends HasComponents> mapEntryFieldLayoutProvider = FlexLayoutHelpers::row;
    private SerializableSupplier<? extends HasComponents> objectFieldLayoutProvider = FlexLayoutHelpers::column;
    private SerializableSupplier<? extends HasComponents> objectFieldGroupLayoutProvider = FlexLayoutHelpers::row;
    private Collection<String> groupLayoutStyleNames = new ArrayList<String>(Arrays.asList("object-field-group-%s", "object-field-group"));
    private Collection<String> groupComponentStyleNames = new ArrayList<String>(Arrays.asList("object-field-group-element", "object-field-group-element-%s"));
    private final Map<Class<?>, SerializableSupplier<?>> instanceSuppliers = new HashMap();
    private final Map<Class<?>, SerializableSupplier<?>> emptyCollectionSuppliers = new HashMap();
    private SerializableSupplier<Map<?, ?>> emptyMapSupplier = LinkedHashMap::new;

    private static void setLabel(Object component, String label) {
        if (component instanceof HasLabel) {
            ((HasLabel)component).setLabel(label);
        }
    }

    private static String[] sanitiseStyles(Collection<String> strings, String groupName) {
        return (String[])strings.stream().map(style -> String.format(style, groupName.replace(' ', '_'))).toArray(String[]::new);
    }

    public ObjectFieldFactory() {
        this.emptyCollectionSuppliers.putAll(REFERENCE_COLLECTION_TYPES);
    }

    protected <T, C extends Collection<T>> CollectionField<T, C> buildCollectionField(Property<?, T> elementProperty, Class<? extends Collection<?>> collectionType, PropertyComponentBuilder callbackFactory) {
        return new CollectionField(this.getEmptyCollectionProvider(collectionType), this.getCollectionFieldLayoutProvider(), (SerializableSupplier & Serializable)() -> (Component)callbackFactory.buildPropertyField(elementProperty).orElseThrow(() -> new IllegalArgumentException(String.format("cannot build collection element field (type %s)", elementProperty.getType().getSimpleName()))));
    }

    protected <K, V> MapField<K, V> buildMapField(final Property<?, K> keyProperty, final Property<?, V> valueProperty, final PropertyComponentBuilder callbackFactory) {
        return new MapField<K, V>(this.getEmptyMapSupplier(), this.getMapFieldLayoutProvider(), new CollectionValueComponentProvider<Map.Entry<K, V>, MapEntryField<K, V>>(){

            @Override
            public MapEntryField<K, V> provideComponent(int index, CollectionController controller) {
                return new MapEntryField(ObjectFieldFactory.this.getMapEntryFieldLayoutProvider(), (SerializableSupplier & Serializable)() -> (Component)callbackFactory.buildPropertyField(keyProperty).orElseThrow(() -> new IllegalArgumentException(String.format("cannot build map key element field (type %s)", keyProperty.getType().getSimpleName()))), (SerializableSupplier & Serializable)() -> (Component)callbackFactory.buildPropertyField(valueProperty).orElseThrow(() -> new IllegalArgumentException(String.format("cannot build map value element field (type %s)", valueProperty.getType().getSimpleName()))));
            }
        });
    }

    protected PropertyComponentBuilder buildAndConfigureComponentBuilder() {
        SimplePropertyComponentBuilder result = new SimplePropertyComponentBuilder().withoutDefaultLabel().withRegisteredBuilder(property -> property.getMetadata().containsKey("show-as") && property.getMetadata().get("show-as").hasValueOfType(Class.class) && HasValue.class.isAssignableFrom((Class)property.getMetadata().get("show-as").getValue()), property -> (HasValue)ReflectTools.newInstance((Class)property.getMetadata().get("show-as").getValue())).withRegisteredBuilder(property -> property.getMetadata().containsKey("build-with") && property.getMetadata().get("build-with").hasValueOfType(Class.class) && FieldBuilder.class.isAssignableFrom((Class)property.getMetadata().get("build-with").getValue()), property -> ((FieldBuilder)ReflectTools.newInstance((Class)property.getMetadata().get("build-with").getValue())).buildPropertyField(property)).withRegisteredBuilder(property -> property.getMetadata().containsKey("available-items") && property.getMetadata().get("available-items").hasValueOfType(Collection.class) && property.getMetadata().containsKey("collection-element") && property.getMetadata().get("collection-element").hasValueOfType(Property.class) && ((Property)property.getMetadata().get("collection-element").getValue()).getType().isEnum(), property -> new MultiSelectComboBox("", (Collection)((List)property.getMetadata().get("available-items").getValue()))).withRegisteredBuilder(property -> property.getMetadata().containsKey("available-items") && property.getMetadata().get("available-items").hasValueOfType(Collection.class) && !property.getMetadata().containsKey("collection-element"), property -> new ComboBox("", (Collection)((List)property.getMetadata().get("available-items").getValue()))).withRegisteredType(Boolean.class, SuperCheckbox::new).withRegisteredType(Boolean.TYPE, SuperCheckbox::new).withRegisteredType(Integer.class, SuperIntegerField::new).withRegisteredType(Integer.TYPE, SuperIntegerField::new).withRegisteredType(Long.class, SuperLongField::new).withRegisteredType(Long.TYPE, SuperLongField::new).withRegisteredType(Double.class, SuperDoubleField::new).withRegisteredType(Double.TYPE, SuperDoubleField::new).withRegisteredType(BigDecimal.class, SuperBigDecimalField::new).withRegisteredType(LocalDate.class, SuperDatePicker::new).withRegisteredType(LocalDateTime.class, SuperDateTimePicker::new).withRegisteredBuilder(String.class, def -> def.getMetadata().containsKey("multiline") && EXPECTED_BOOLEAN_TYPES.contains(def.getMetadata().get("multiline").getValueType()) && Objects.equals(Boolean.TRUE, def.getMetadata().get("multiline").getValue()) ? new SuperTextArea() : new SuperTextField());
        result.withRegisteredBuilder(def -> def.getMetadata().containsKey("collection-element"), def -> {
            Class collectionType = def.getType();
            Property listDef = (Property)def.getMetadata().get("collection-element").getValue();
            return this.buildCollectionField(listDef, collectionType, result);
        }).withRegisteredBuilder(def -> def.getMetadata().containsKey("map-key") && def.getMetadata().containsKey("map-value"), def -> {
            Property keyDef = (Property)def.getMetadata().get("map-key").getValue();
            Property valueDef = (Property)def.getMetadata().get("map-value").getValue();
            return this.buildMapField(keyDef, valueDef, result);
        });
        result.setDefaultBuilder(def -> {
            try {
                ObjectField field = new ObjectField(def.getType(), (SerializableSupplier & Serializable)() -> this.getInstanceProvider(def.getType()).get(), this.getObjectFieldLayoutProvider());
                this.configureObjectField(field);
                field.repaint();
                return field;
            }
            catch (RuntimeException iae) {
                LOGGER.info("could not construct an instance of {} due to an error: \"{}\"; as a result LabelField is created instead of ObjectField", (Object)def.getType().getSimpleName(), (Object)iae.getMessage());
                return new LabelField();
            }
        });
        return result;
    }

    private Set<PropertyMetadata> getEnumMetadata(Class<?> type) {
        return type.isEnum() ? Collections.singleton(new PropertyMetadata("available-items", List.class, Arrays.asList(type.getEnumConstants()))) : Collections.emptySet();
    }

    protected PropertyProvider buildAndConfigurePropertyProvider() {
        return new ReflectivePropertyProvider().withMetadataProvider(new AnnotationMetadataProvider().withRegisteredAnnotation("group", FieldGroup.class, String.class, FieldGroup::value).withRegisteredAnnotation("order", FieldOrder.class, Integer.TYPE, FieldOrder::value).withRegisteredAnnotation("multiline", BigField.class).withRegisteredAnnotation("caption", FieldCaption.class, String.class, FieldCaption::value).withRegisteredAnnotation("show-as", ShowFieldAs.class, Class.class, ShowFieldAs::value).withRegisteredAnnotation("build-with", BuildFieldWith.class, Class.class, BuildFieldWith::value).withRegisteredAnnotation("component-id", ComponentId.class, String.class, ComponentId::value).withRegisteredAnnotation("component-style-name", ComponentStyle.class, String[].class, ComponentStyle::value), (name, field, setter, getter) -> setter == null ? Collections.singleton(new PropertyMetadata("read-only", Boolean.TYPE, true)) : Collections.emptySet(), (name, field, setter, getter) -> this.getEnumMetadata(field.getType()), (name, field, setter, getter) -> {
            if (Collection.class.isAssignableFrom(field.getType())) {
                return ReflectTools.extractGenericType(field, 0).map(type -> {
                    LinkedHashSet<PropertyMetadata> result = new LinkedHashSet<PropertyMetadata>();
                    result.add(new PropertyMetadata("collection-element", Property.class, new Property(field.getDeclaringClass(), name, type, null, null, new PropertyMetadata[0])));
                    result.addAll(this.getEnumMetadata((Class<?>)type));
                    return result;
                }).orElse(Collections.emptySet());
            }
            return Collections.emptySet();
        }, (name, field, setter, getter) -> {
            if (Map.class.isAssignableFrom(field.getType())) {
                ArrayList metadata = new ArrayList();
                ReflectTools.extractGenericType(field, 0).map(type -> new PropertyMetadata("map-key", Property.class, new Property(field.getDeclaringClass(), name, type, null, null, (Collection<PropertyMetadata>)this.getEnumMetadata((Class<?>)type)))).ifPresent(metadata::add);
                ReflectTools.extractGenericType(field, 1).map(type -> new PropertyMetadata("map-value", Property.class, new Property(field.getDeclaringClass(), name, type, null, null, (Collection<PropertyMetadata>)this.getEnumMetadata((Class<?>)type)))).ifPresent(metadata::add);
                return metadata.size() == 2 ? metadata : Collections.emptySet();
            }
            return Collections.emptySet();
        });
    }

    protected PropertyGroupingProvider buildAndConfigureGroupingProvider() {
        return new MetadataBasedGroupingProvider().withGroupingMetadataName("group").withSortingMetadataName("order");
    }

    protected <T> Collection<ComponentConfigurator<T>> buildComponentConfigurators(Class<T> dataType) {
        return Arrays.asList((object, definition, component) -> {
            Map<String, PropertyMetadata> metadataMap = definition.getMetadata();
            if (metadataMap.containsKey("caption") && metadataMap.get("caption").getValue() != null) {
                ObjectFieldFactory.setLabel(component, metadataMap.get("caption").getValue().toString());
            } else {
                ObjectFieldFactory.setLabel(component, StringTools.humanReadable(definition.getName()));
            }
        }, (object, definition, component) -> {
            if (definition.getMetadata().containsKey("read-only") && definition.getMetadata().get("read-only").getValueType() == Boolean.TYPE) {
                component.setReadOnly(((Boolean)definition.getMetadata().get("read-only").getValue()).booleanValue());
            }
        }, (object, definition, component) -> {
            if (component instanceof HasStyle && definition.getMetadata().containsKey("component-style-name") && definition.getMetadata().get("component-style-name").hasValueOfType(String[].class)) {
                ((HasStyle)component).addClassNames((String[])definition.getMetadata().get("component-style-name").getValue());
            }
            if (definition.getMetadata().containsKey("component-id") && definition.getMetadata().get("component-id").getValue() != null) {
                ((Component)component).setId(definition.getMetadata().get("component-id").getValue().toString());
            }
        });
    }

    protected PropertyGroupLayoutProvider buildAndConfigureGroupLayoutProvider() {
        return new PropertyGroupLayoutProvider(){

            @Override
            public <T, C extends Component> Optional<C> buildGroupLayout(String groupName, List<Property<T, ?>> definitions) {
                if (definitions.size() < 2) {
                    return Optional.empty();
                }
                Component layout = (Component)ObjectFieldFactory.this.getObjectFieldGroupLayoutProvider().get();
                if (layout instanceof HasStyle) {
                    ((HasStyle)layout).addClassNames(ObjectFieldFactory.sanitiseStyles(ObjectFieldFactory.this.getGroupLayoutStyleNames(), groupName));
                }
                return Optional.of(layout);
            }
        };
    }

    protected Collection<ComponentGroupConfigurator> buildComponentGroupConfigurators() {
        return Collections.singleton(new ComponentGroupConfigurator(){

            @Override
            public <T> void configureComponentGroup(T object, String groupName, List<Property<T, ?>> definitions, List<? extends HasValue<?, ?>> components) {
                if (groupName != null) {
                    components.stream().filter(HasStyle.class::isInstance).map(HasStyle.class::cast).forEach(component -> component.addClassNames(ObjectFieldFactory.sanitiseStyles(ObjectFieldFactory.this.getGroupComponentStyleNames(), groupName)));
                }
            }
        });
    }

    public <T> ObjectField<T> buildAndConfigureObjectField(Class<T> type) {
        return this.buildAndConfigureObjectField(type, true);
    }

    public <T> ObjectField<T> buildAndConfigureObjectField(Class<T> type, boolean repaint) {
        return this.buildAndConfigureObjectField(type, this.getInstanceProvider(type), repaint);
    }

    public <T> ObjectField<T> buildAndConfigureObjectField(Class<T> type, SerializableSupplier<T> newInstanceProvider) {
        return this.buildAndConfigureObjectField(type, newInstanceProvider, true);
    }

    public <T> ObjectField<T> buildAndConfigureObjectField(Class<T> type, SerializableSupplier<T> newInstanceProvider, boolean repaint) {
        ObjectField<T> objectField = new ObjectField<T>(type, newInstanceProvider, this.getObjectFieldLayoutProvider());
        this.configureObjectField(objectField);
        if (repaint) {
            objectField.repaint();
        }
        return objectField;
    }

    public final <T> ObjectField<T> configureObjectField(ObjectField<T> objectField) {
        return objectField.withPropertyProvider(this.buildAndConfigurePropertyProvider()).withPropertyGroupingProvider(this.buildAndConfigureGroupingProvider()).withPropertyComponentBuilder(this.buildAndConfigureComponentBuilder()).withGroupLayoutProvider(this.buildAndConfigureGroupLayoutProvider()).withComponentConfigurators(this.buildComponentConfigurators(objectField.getDataType())).withComponentGroupConfigurators(this.buildComponentGroupConfigurators());
    }

    public <T> void registerInstanceProvider(Class<T> type, SerializableSupplier<T> supplier) {
        this.instanceSuppliers.put(type, supplier);
    }

    public <T> SerializableSupplier<T> getInstanceProvider(Class<T> type) {
        if (!this.instanceSuppliers.containsKey(type)) {
            return (SerializableSupplier & Serializable)() -> ReflectTools.newInstance(type);
        }
        return this.instanceSuppliers.get(type);
    }

    public <E, C extends Collection<E>> void registerEmptyCollectionProvider(Class<C> collectionType, SerializableSupplier<C> supplier) {
        this.emptyCollectionSuppliers.put(collectionType, supplier);
    }

    public <E, C extends Collection<E>> SerializableSupplier<C> getEmptyCollectionProvider(Class<C> type) {
        if (this.emptyCollectionSuppliers.containsKey(type)) {
            return this.emptyCollectionSuppliers.get(type);
        }
        throw new IllegalArgumentException(String.format("unknown collection type %s", type.getName()));
    }

    public <K, V> SerializableSupplier<Map<K, V>> getEmptyMapSupplier() {
        return this.emptyMapSupplier;
    }

    public void setEmptyMapSupplier(SerializableSupplier<Map<?, ?>> emptyMapSupplier) {
        this.emptyMapSupplier = emptyMapSupplier;
    }

    public CollectionLayoutProvider<?> getCollectionFieldLayoutProvider() {
        return this.collectionFieldLayoutProvider;
    }

    public void setCollectionFieldLayoutProvider(CollectionLayoutProvider<?> collectionFieldLayoutProvider) {
        this.collectionFieldLayoutProvider = collectionFieldLayoutProvider;
    }

    public CollectionLayoutProvider<?> getMapFieldLayoutProvider() {
        return this.mapFieldLayoutProvider;
    }

    public void setMapFieldLayoutProvider(CollectionLayoutProvider<?> mapFieldLayoutProvider) {
        this.mapFieldLayoutProvider = mapFieldLayoutProvider;
    }

    public <L extends Component> SerializableSupplier<L> getMapEntryFieldLayoutProvider() {
        return this.mapEntryFieldLayoutProvider;
    }

    public <L extends Component> void setMapEntryFieldLayoutProvider(SerializableSupplier<L> mapEntryFieldLayoutProvider) {
        this.mapEntryFieldLayoutProvider = mapEntryFieldLayoutProvider;
    }

    public <L extends Component> SerializableSupplier<L> getObjectFieldLayoutProvider() {
        return this.objectFieldLayoutProvider;
    }

    public <L extends Component> void setObjectFieldLayoutProvider(SerializableSupplier<L> objectFieldLayoutProvider) {
        this.objectFieldLayoutProvider = objectFieldLayoutProvider;
    }

    public <L extends Component> SerializableSupplier<L> getObjectFieldGroupLayoutProvider() {
        return this.objectFieldGroupLayoutProvider;
    }

    public <L extends Component> void setObjectFieldGroupLayoutProvider(SerializableSupplier<L> objectFieldGroupLayoutProvider) {
        this.objectFieldGroupLayoutProvider = objectFieldGroupLayoutProvider;
    }

    public Collection<String> getGroupLayoutStyleNames() {
        return this.groupLayoutStyleNames;
    }

    public void setGroupLayoutStyleNames(Collection<String> groupLayoutStyleNames) {
        this.groupLayoutStyleNames = groupLayoutStyleNames;
    }

    public Collection<String> getGroupComponentStyleNames() {
        return this.groupComponentStyleNames;
    }

    public void setGroupComponentStyleNames(Collection<String> groupComponentStyleNames) {
        this.groupComponentStyleNames = groupComponentStyleNames;
    }
}

