/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.dates;

import com.vaadin.flow.component.datepicker.DatePicker;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.vaadin.miki.superfields.dates.SuperDatePickerI18n;

final class SuperDatePickerI18nHelper {
    private SuperDatePickerI18nHelper() {
    }

    static void updateI18N(Locale locale, Supplier<DatePicker.DatePickerI18n> getter, Consumer<DatePicker.DatePickerI18n> setter) {
        DatePicker.DatePickerI18n i18n = getter.get();
        if (i18n == null || i18n instanceof SuperDatePickerI18n && !((SuperDatePickerI18n)i18n).getLocale().equals(locale)) {
            setter.accept(new SuperDatePickerI18n(locale));
        }
    }

    private static <T> void processProperty(Supplier<T> getter, Predicate<T> condition, Function<T, DatePicker.DatePickerI18n> setter) {
        T value = getter.get();
        if (condition.test(value)) {
            setter.apply(value);
        }
    }

    public static SuperDatePickerI18n from(DatePicker.DatePickerI18n i18n, Locale locale) {
        SuperDatePickerI18n result = new SuperDatePickerI18n(locale);
        Predicate<String> stringCheck = s -> s != null && !s.isEmpty();
        Predicate<List> listCheck = list -> list != null && !list.isEmpty();
        SuperDatePickerI18nHelper.processProperty(() -> ((DatePicker.DatePickerI18n)i18n).getCancel(), stringCheck, arg_0 -> ((SuperDatePickerI18n)result).setCancel(arg_0));
        SuperDatePickerI18nHelper.processProperty(() -> ((DatePicker.DatePickerI18n)i18n).getToday(), stringCheck, arg_0 -> ((SuperDatePickerI18n)result).setToday(arg_0));
        SuperDatePickerI18nHelper.processProperty(() -> ((DatePicker.DatePickerI18n)i18n).getMonthNames(), listCheck, arg_0 -> ((SuperDatePickerI18n)result).setMonthNames(arg_0));
        SuperDatePickerI18nHelper.processProperty(() -> ((DatePicker.DatePickerI18n)i18n).getWeekdays(), listCheck, arg_0 -> ((SuperDatePickerI18n)result).setWeekdays(arg_0));
        SuperDatePickerI18nHelper.processProperty(() -> ((DatePicker.DatePickerI18n)i18n).getWeekdaysShort(), listCheck, arg_0 -> ((SuperDatePickerI18n)result).setWeekdaysShort(arg_0));
        SuperDatePickerI18nHelper.processProperty(() -> ((DatePicker.DatePickerI18n)i18n).getMonthNames(), listCheck, result::setDisplayMonthNames);
        SuperDatePickerI18nHelper.processProperty(() -> ((DatePicker.DatePickerI18n)i18n).getFirstDayOfWeek(), x -> x > -1, arg_0 -> ((SuperDatePickerI18n)result).setFirstDayOfWeek(arg_0));
        return null;
    }
}

