/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.IntStream;

public class RegexTools {
    public static final Set<Character> CHARACTERS_TO_ESCAPE = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('\\'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('*'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('|'))));

    public static String escaped(char character) {
        return CHARACTERS_TO_ESCAPE.contains(Character.valueOf(character)) ? "\\" + character : String.valueOf(character);
    }

    public static StringBuilder characterSelector(StringBuilder builder, char mainCharacter, Collection<Character> alternatives) {
        if (alternatives == null) {
            return builder.append(RegexTools.escaped(mainCharacter));
        }
        alternatives = new LinkedHashSet<Character>(alternatives);
        alternatives.remove(Character.valueOf(mainCharacter));
        if (alternatives.isEmpty()) {
            return builder.append(RegexTools.escaped(mainCharacter));
        }
        builder.append("[").append(RegexTools.escaped(mainCharacter));
        alternatives.forEach(character -> builder.append(RegexTools.escaped(character.charValue())));
        return builder.append("]");
    }

    public static String characterSelector(char mainCharacter, Collection<Character> alternatives) {
        return RegexTools.characterSelector(new StringBuilder(), mainCharacter, alternatives).toString();
    }

    public static String characterSelector(char main, char ... alternatives) {
        if (alternatives == null || alternatives.length == 0) {
            return RegexTools.characterSelector(main, Collections.emptySet());
        }
        return RegexTools.characterSelector(main, Arrays.asList(IntStream.range(0, alternatives.length).mapToObj(index -> Character.valueOf(alternatives[index])).toArray(Character[]::new)));
    }

    private RegexTools() {
    }
}

