/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.itemgrid;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.binder.HasItems;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithItemsMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.itemgrid.CellGenerator;
import org.vaadin.miki.superfields.itemgrid.CellInformation;
import org.vaadin.miki.superfields.itemgrid.CellSelectionEvent;
import org.vaadin.miki.superfields.itemgrid.CellSelectionHandler;
import org.vaadin.miki.superfields.itemgrid.RowComponentGenerator;
import org.vaadin.miki.superfields.itemgrid.RowPadding;
import org.vaadin.miki.superfields.itemgrid.RowPaddingStrategies;
import org.vaadin.miki.superfields.itemgrid.RowPaddingStrategy;

@Tag(value="item-grid")
public class ItemGrid<T>
extends CustomField<T>
implements HasItems<T>,
HasStyle,
WithItemsMixin<T, ItemGrid<T>>,
WithIdMixin<ItemGrid<T>>,
WithHelperMixin<ItemGrid<T>>,
WithHelperPositionableMixin<ItemGrid<T>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T, ItemGrid<T>> {
    public static final int DEFAULT_COLUMN_COUNT = 3;
    public static final String DEFAULT_SELECTED_ITEM_CLASS_NAME = "item-grid-selected-cell";
    private final HasComponents contents;
    private final List<CellInformation<T>> cells = new ArrayList<CellInformation<T>>();
    private CellInformation<T> markedAsSelected;
    private transient CellGenerator<T> cellGenerator;
    private transient CellGenerator<T> paddingCellGenerator;
    private boolean paddingCellsClickable = false;
    private transient CellSelectionHandler<T> cellSelectionHandler;
    private transient RowComponentGenerator<?> rowComponentGenerator = ItemGrid::defaultRowComponentGenerator;
    private RowPaddingStrategy rowPaddingStrategy = RowPaddingStrategies.NO_PADDING;
    private int columnCount = 3;

    public static <V> void defaultCellSelectionHandler(CellSelectionEvent<V> event) {
        if (event.isSelected()) {
            event.getCellInformation().getComponent().getElement().getClassList().add((Object)DEFAULT_SELECTED_ITEM_CLASS_NAME);
        } else {
            event.getCellInformation().getComponent().getElement().getClassList().remove((Object)DEFAULT_SELECTED_ITEM_CLASS_NAME);
        }
    }

    public static Div defaultMainContainerSupplier() {
        Div result = new Div();
        result.addClassName("item-grid-contents");
        return result;
    }

    public static <V> Component defaultCellGenerator(V item, int row, int col) {
        Span result = new Span(String.valueOf(item));
        result.addClassNames(new String[]{"item-grid-cell", "item-grid-cell-column-" + ItemGrid.evenOrOdd(col), "item-grid-cell-row-" + ItemGrid.evenOrOdd(row)});
        return result;
    }

    public static Div defaultRowComponentGenerator(int rowNumber) {
        Div row = new Div();
        row.addClassNames(new String[]{"item-grid-row", "item-grid-row-" + ItemGrid.evenOrOdd(rowNumber)});
        return row;
    }

    private static String evenOrOdd(int number) {
        return number % 2 == 0 ? "even" : "odd";
    }

    @SafeVarargs
    public ItemGrid(T ... items) {
        this(null, null, null, items);
    }

    @SafeVarargs
    public ItemGrid(CellGenerator<T> generator, T ... items) {
        this(null, generator, null, items);
    }

    @SafeVarargs
    public ItemGrid(CellGenerator<T> generator, CellSelectionHandler<T> handler, T ... items) {
        this(null, (CellGenerator<Object>)generator, (CellSelectionHandler<Object>)handler, items);
    }

    @SafeVarargs
    public ItemGrid(T defaultValue, CellGenerator<T> generator, CellSelectionHandler<T> handler, T ... items) {
        this(defaultValue, ItemGrid::defaultMainContainerSupplier, generator, handler, items);
    }

    @SafeVarargs
    public <C extends Component> ItemGrid(T defaultValue, Supplier<C> mainContainerSupplier, CellGenerator<T> generator, CellSelectionHandler<T> handler, T ... items) {
        super(defaultValue);
        this.contents = (HasComponents)mainContainerSupplier.get();
        this.add(new Component[]{(Component)this.contents});
        this.setCellGenerator(generator);
        this.setCellSelectionHandler(handler);
        this.setItems(items);
    }

    protected final void repaintAllItems() {
        this.repaintAllItems(this.cells.stream().filter(CellInformation::isValueCell).map(CellInformation::getValue).toList());
    }

    protected final CellInformation<T> buildPaddingCell(int row, int column) {
        Component itemComponent = this.getPaddingCellGenerator().generateComponent(null, row, column);
        return new CellInformation(row, column, itemComponent);
    }

    protected final CellInformation<T> buildValueCell(T item, int row, int column) {
        Component itemComponent = this.getCellGenerator().generateComponent(item, row, column);
        return new CellInformation<T>(row, column, item, itemComponent);
    }

    protected void repaintAllItems(Collection<T> itemCollection) {
        Object currentValue = this.getValue();
        this.contents.removeAll();
        this.cells.clear();
        int row = 0;
        int itemsLeft = itemCollection.size();
        Iterator<T> iterator = itemCollection.iterator();
        ArrayList<CellInformation> currentRow = new ArrayList<CellInformation>();
        RowPadding padding = this.getRowPaddingStrategy().getRowPadding(row, this.getColumnCount(), itemsLeft);
        while (itemsLeft > 0) {
            int column;
            if (padding.getBeginning() + padding.getEnd() >= this.getColumnCount()) {
                throw new IllegalStateException(String.format("row padding requires %d and %d cells - that is too many, as there are %d columns", padding.getBeginning(), padding.getEnd(), this.getColumnCount()));
            }
            currentRow.clear();
            for (column = 0; column < padding.getBeginning(); ++column) {
                currentRow.add(this.buildPaddingCell(row, column));
            }
            while (iterator.hasNext() && column < this.getColumnCount() - padding.getEnd() && itemsLeft-- >= 0) {
                currentRow.add(this.buildValueCell(iterator.next(), row, column));
                ++column;
            }
            if (padding.getEnd() > 0) {
                for (int zmp1 = column; zmp1 < Math.min(this.getColumnCount(), column + padding.getEnd()); ++zmp1) {
                    currentRow.add(this.buildPaddingCell(row, zmp1));
                }
            }
            HasComponents rowContainer = (HasComponents)this.getRowComponentGenerator().generateRowComponent(row);
            currentRow.forEach(cellInformation -> {
                this.processCell((CellInformation<T>)cellInformation, (T)currentValue);
                rowContainer.add(new Component[]{cellInformation.getComponent()});
            });
            this.contents.add(new Component[]{(Component)rowContainer});
            padding = this.getRowPaddingStrategy().getRowPadding(++row, this.getColumnCount(), itemsLeft);
        }
    }

    private void processCell(CellInformation<T> cellInformation, T currentValue) {
        boolean selected = cellInformation.isValueCell() && Objects.equals(cellInformation.getValue(), currentValue);
        this.getCellSelectionHandler().cellSelectionChanged(new CellSelectionEvent<T>(cellInformation, selected));
        this.registerClickEvents(cellInformation);
        this.cells.add(cellInformation);
        if (selected) {
            this.markedAsSelected = cellInformation;
        }
    }

    protected void registerClickEvents(CellInformation<T> information) {
        information.getComponent().getElement().addEventListener("click", (DomEventListener & Serializable)event -> this.clickCellAndUpdateValue(information));
    }

    private void clickCellAndUpdateValue(CellInformation<T> information) {
        if (this.arePaddingCellsClickable() || information.isValueCell()) {
            this.clickCell(information);
            this.updateValue();
        }
    }

    protected void clickCell(CellInformation<T> information) {
        if (this.markedAsSelected == null) {
            this.markedAsSelected = information;
            this.getCellSelectionHandler().cellSelectionChanged(new CellSelectionEvent<T>(this.markedAsSelected, true));
        } else if (Objects.equals(this.markedAsSelected, information)) {
            this.getCellSelectionHandler().cellSelectionChanged(new CellSelectionEvent<T>(information, false));
            this.markedAsSelected = null;
        } else {
            this.getCellSelectionHandler().cellSelectionChanged(new CellSelectionEvent<T>(this.markedAsSelected, false));
            this.markedAsSelected = information;
            this.getCellSelectionHandler().cellSelectionChanged(new CellSelectionEvent<T>(this.markedAsSelected, true));
        }
    }

    protected T generateModelValue() {
        return (T)(this.markedAsSelected == null ? this.getEmptyValue() : this.markedAsSelected.getValue());
    }

    protected void setPresentationValue(T t) {
        if (Objects.equals(t, this.getEmptyValue()) && this.markedAsSelected != null) {
            this.clickCell(this.markedAsSelected);
        } else if (!Objects.equals(t, this.getEmptyValue())) {
            this.getCellInformation(t).ifPresent(this::clickCell);
        }
    }

    public void setCellGenerator(CellGenerator<T> cellGenerator) {
        this.cellGenerator = Optional.ofNullable(cellGenerator).orElse(ItemGrid::defaultCellGenerator);
        this.repaintAllItems();
    }

    public CellGenerator<T> getCellGenerator() {
        return this.cellGenerator;
    }

    public ItemGrid<T> withCellGenerator(CellGenerator<T> generator) {
        this.setCellGenerator(generator);
        return this;
    }

    public void setCellSelectionHandler(CellSelectionHandler<T> cellSelectionHandler) {
        this.cellSelectionHandler = Optional.ofNullable(cellSelectionHandler).orElse(ItemGrid::defaultCellSelectionHandler);
        this.repaintAllItems();
    }

    public CellSelectionHandler<T> getCellSelectionHandler() {
        return this.cellSelectionHandler;
    }

    public ItemGrid<T> withCellSelectionHandler(CellSelectionHandler<T> handler) {
        this.setCellSelectionHandler(handler);
        return this;
    }

    public long getRowCount() {
        return ((Component)this.contents).getChildren().count();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = Math.max(1, columnCount);
        this.repaintAllItems();
    }

    public ItemGrid<T> withColumnCount(int columnCount) {
        this.setColumnCount(columnCount);
        return this;
    }

    public void setItems(Collection<T> collection) {
        this.repaintAllItems(collection);
    }

    public int size() {
        return this.cells.size();
    }

    public List<CellInformation<T>> getCellInformation() {
        return new ArrayList<CellInformation<T>>(this.cells);
    }

    public Optional<CellInformation<T>> getSelectedCellInformation() {
        return Optional.ofNullable(this.markedAsSelected);
    }

    public Optional<CellInformation<T>> getCellInformation(T value) {
        return this.cells.stream().filter(cell -> Objects.equals(cell.getValue(), value)).findFirst();
    }

    public Optional<CellInformation<T>> getCellInformation(int row, int column) {
        return this.cells.stream().filter(cell -> cell.getRow() == row && cell.getColumn() == column).findFirst();
    }

    public List<CellInformation<T>> getRowCellInformation(int row) {
        return this.cells.stream().filter(cell -> cell.getRow() == row).toList();
    }

    public List<CellInformation<T>> getColumnCellInformation(int column) {
        return this.cells.stream().filter(cell -> cell.getColumn() == column).toList();
    }

    public Stream<Component> getCellComponents() {
        return this.cells.stream().map(CellInformation::getComponent);
    }

    public void setRowComponentGenerator(RowComponentGenerator<?> rowComponentGenerator) {
        this.rowComponentGenerator = rowComponentGenerator == null ? ItemGrid::defaultRowComponentGenerator : rowComponentGenerator;
        this.repaintAllItems();
    }

    public RowComponentGenerator<?> getRowComponentGenerator() {
        return this.rowComponentGenerator;
    }

    public ItemGrid<T> withRowComponentGenerator(RowComponentGenerator<?> generator) {
        this.setRowComponentGenerator(generator);
        return this;
    }

    public void setRowPaddingStrategy(RowPaddingStrategy rowPaddingStrategy) {
        this.rowPaddingStrategy = Objects.requireNonNullElse(rowPaddingStrategy, RowPaddingStrategies.NO_PADDING);
        this.repaintAllItems();
    }

    public RowPaddingStrategy getRowPaddingStrategy() {
        return this.rowPaddingStrategy;
    }

    public ItemGrid<T> withRowPaddingStrategy(RowPaddingStrategy rowPaddingStrategy) {
        this.setRowPaddingStrategy(rowPaddingStrategy);
        return this;
    }

    public CellGenerator<T> getPaddingCellGenerator() {
        return Objects.requireNonNullElse(this.paddingCellGenerator, this.getCellGenerator());
    }

    public void setPaddingCellGenerator(CellGenerator<T> paddingCellGenerator) {
        this.paddingCellGenerator = paddingCellGenerator;
    }

    public ItemGrid<T> withPaddingCellGenerator(CellGenerator<T> paddingCellGenerator) {
        this.setPaddingCellGenerator(paddingCellGenerator);
        return this;
    }

    public boolean arePaddingCellsClickable() {
        return this.paddingCellsClickable;
    }

    public void setPaddingCellsClickable(boolean paddingCellsClickable) {
        this.paddingCellsClickable = paddingCellsClickable;
    }

    public ItemGrid<T> withPaddingCellsClickable(boolean paddingCellsClickable) {
        this.setPaddingCellsClickable(paddingCellsClickable);
        return this;
    }

    void simulateCellClick(int row, int col) {
        this.getCellInformation(row, col).ifPresent(this::clickCellAndUpdateValue);
    }
}

