/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.itemgrid;

import java.util.Objects;

public final class RowPadding {
    public static final RowPadding NONE = new RowPadding(0, 0);
    private final int beginning;
    private final int end;

    public static RowPadding centred(int cells, int columns, boolean whenOddPutMoreToBeginning) {
        if (cells >= columns || columns == 0) {
            return NONE;
        }
        int split = (columns - cells) / 2;
        if ((columns - cells) % 2 == 0) {
            return new RowPadding(split, split);
        }
        if (whenOddPutMoreToBeginning) {
            return new RowPadding(split + 1, split);
        }
        return new RowPadding(split, split + 1);
    }

    public RowPadding(int beginning, int end) {
        if (beginning < 0 || end < 0) {
            throw new IllegalArgumentException("row padding cannot have negative padding at beginning or end");
        }
        this.beginning = beginning;
        this.end = end;
    }

    public int getBeginning() {
        return this.beginning;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowPadding that = (RowPadding)o;
        return this.getBeginning() == that.getBeginning() && this.getEnd() == that.getEnd();
    }

    public int hashCode() {
        return Objects.hash(this.getBeginning(), this.getEnd());
    }
}

