/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.lazyload;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Optional;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.superfields.lazyload.ComponentObservationEvent;
import org.vaadin.miki.superfields.lazyload.ComponentObserver;

public class LazyLoad<C extends Component>
extends Composite<LazyLoadElement>
implements WithIdMixin<LazyLoad<C>>,
HasStyle {
    public static final String EMPTY_CLASS_NAME = "lazy-load-empty";
    public static final String LOADED_CLASS_NAME = "lazy-loaded";
    private final SerializableSupplier<C> componentProvider;
    private final ComponentObserver observer = new ComponentObserver(new double[0]);
    private final boolean onlyLoadedOnce;
    private C lazyLoadedContent = null;

    public LazyLoad(C contents) {
        this(contents, false);
    }

    public LazyLoad(SerializableSupplier<C> supplier) {
        this(supplier, false);
    }

    public LazyLoad(C contents, boolean removeOnHide) {
        this((SerializableSupplier<C>)(SerializableSupplier & Serializable)() -> contents, removeOnHide);
    }

    public LazyLoad(SerializableSupplier<C> supplier, boolean removeOnHide) {
        this.componentProvider = supplier;
        this.onlyLoadedOnce = !removeOnHide;
        ((LazyLoadElement)this.getContent()).addClassNames(new String[]{EMPTY_CLASS_NAME});
        ((LazyLoadElement)this.getContent()).add(new Component[]{this.observer});
        this.observer.addComponentObservationListener(this::onComponentObserved);
        this.observer.observe(new Component[]{this});
    }

    private void onComponentObserved(ComponentObservationEvent event) {
        if (event.isFullyVisible()) {
            this.onNowVisible();
            if (this.onlyLoadedOnce) {
                this.observer.unobserve(new Component[]{this});
            }
        } else if (event.isNotVisible()) {
            this.onNowHidden();
        }
    }

    protected void onNowHidden() {
        if (this.lazyLoadedContent != null) {
            ((LazyLoadElement)this.getContent()).removeClassName(LOADED_CLASS_NAME);
            ((LazyLoadElement)this.getContent()).addClassName(EMPTY_CLASS_NAME);
            ((LazyLoadElement)this.getContent()).remove(new Component[]{this.lazyLoadedContent});
            this.lazyLoadedContent = null;
        }
    }

    protected void onNowVisible() {
        if (this.lazyLoadedContent == null) {
            ((LazyLoadElement)this.getContent()).removeClassName(EMPTY_CLASS_NAME);
            ((LazyLoadElement)this.getContent()).addClassName(LOADED_CLASS_NAME);
            this.lazyLoadedContent = (Component)this.componentProvider.get();
            ((LazyLoadElement)this.getContent()).add(new Component[]{this.lazyLoadedContent});
        }
    }

    public boolean isOnlyLoadedOnce() {
        return this.onlyLoadedOnce;
    }

    public Optional<C> getLoadedContent() {
        return Optional.ofNullable(this.lazyLoadedContent);
    }

    public boolean isLoaded() {
        return this.lazyLoadedContent == null;
    }

    @Tag(value="lazy-load")
    public static final class LazyLoadElement
    extends Div {
    }
}

