/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.variant;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.text.LabelField;
import org.vaadin.miki.superfields.variant.TypedFieldProvider;
import org.vaadin.miki.util.ComponentTools;

@CssImport(value="./styles/label-positions.css", themeFor="vaadin-custom-field")
public class VariantField
extends CustomField<Object>
implements HasStyle,
WithLabelMixin<VariantField>,
WithHelperMixin<VariantField>,
WithHelperPositionableMixin<VariantField>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<Object>, Object>, Object, VariantField>,
WithIdMixin<VariantField>,
WithLabelPositionableMixin<VariantField> {
    public static final SerializableSupplier<Component> DEFAULT_NULL_COMPONENT_PROVIDER = LabelField::new;
    private final List<TypedFieldProvider<?, ?>> fieldProviders = new ArrayList();
    private SerializableSupplier<Component> nullComponentProvider = DEFAULT_NULL_COMPONENT_PROVIDER;
    private Component field = new LabelField();
    private Class<?> currentType;

    public VariantField(String label, SerializableSupplier<Component> nullComponentProvider, TypedFieldProvider<?, ?> ... providers) {
        this();
        this.withTypedFieldProvider(providers).withNullComponentProvider(nullComponentProvider).setLabel(label);
    }

    public VariantField(String label, TypedFieldProvider<?, ?> ... providers) {
        this(label, DEFAULT_NULL_COMPONENT_PROVIDER, providers);
    }

    public VariantField() {
        this.add(new Component[]{this.field});
    }

    protected Object generateModelValue() {
        if (this.field instanceof HasValue) {
            return ((HasValue)this.field).getValue();
        }
        return null;
    }

    protected void setPresentationValue(Object o) {
        if (this.currentType != null && this.currentType.isInstance(o)) {
            ((HasValue)this.field).setValue(o);
        } else {
            this.remove(new Component[]{this.field});
            Component oldField = this.field;
            if (o != null) {
                this.field = this.fieldProviders.stream().map(provider -> provider.provideComponent(o.getClass())).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("VariantField cannot display value of type %s - none of the registered field providers is suitable", o.getClass())));
                this.currentType = o.getClass();
            } else {
                this.currentType = null;
                this.field = (Component)this.getNullComponentProvider().get();
            }
            if (this.field instanceof HasValue) {
                ((HasValue)this.field).setValue(o);
                ((HasValue)this.field).addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateValue());
                ((HasValue)this.field).setReadOnly(this.isReadOnly());
            }
            ComponentTools.copyProperties(oldField, this.field);
            this.add(new Component[]{this.field});
        }
    }

    public void addTypedFieldProvider(TypedFieldProvider<?, ?> ... fieldProviders) {
        this.fieldProviders.addAll(Arrays.asList(fieldProviders));
    }

    public void removeTypeFieldProvider(TypedFieldProvider<?, ?> provider) {
        this.fieldProviders.remove(provider);
    }

    public final VariantField withTypedFieldProvider(TypedFieldProvider<?, ?> ... fieldProviders) {
        this.addTypedFieldProvider(fieldProviders);
        return this;
    }

    public SerializableSupplier<Component> getNullComponentProvider() {
        return this.nullComponentProvider;
    }

    public void setNullComponentProvider(SerializableSupplier<Component> nullComponentProvider) {
        this.nullComponentProvider = nullComponentProvider;
        if (this.getCurrentType() == null) {
            this.setPresentationValue(null);
        }
    }

    public final VariantField withNullComponentProvider(SerializableSupplier<Component> nullComponentProvider) {
        this.setNullComponentProvider(nullComponentProvider);
        return this;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.field instanceof HasValue) {
            ((HasValue)this.field).setReadOnly(readOnly);
        }
    }

    Class<?> getCurrentType() {
        return this.currentType;
    }

    Component getField() {
        return this.field;
    }
}

