/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.buttons;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.vaadin.miki.events.click.ComponentClickEvent;
import org.vaadin.miki.events.click.ComponentClickListener;
import org.vaadin.miki.events.click.ComponentClickNotifier;
import org.vaadin.miki.events.state.StateChangeEvent;
import org.vaadin.miki.events.state.StateChangeListener;
import org.vaadin.miki.events.state.StateChangeNotifier;
import org.vaadin.miki.markers.Clickable;
import org.vaadin.miki.markers.HasState;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.superfields.buttons.ButtonState;

@Tag(value="multi-click-button")
public class MultiClickButton
extends Composite<Button>
implements WithIdMixin<MultiClickButton>,
ComponentClickNotifier<MultiClickButton>,
Clickable,
HasStyle,
HasSize,
HasEnabled,
HasState<ButtonState>,
StateChangeNotifier<ButtonState, MultiClickButton> {
    private final Button button = new Button("", this::registerButtonClick);
    private final List<ButtonState> states = new ArrayList<ButtonState>();
    private int index = 0;

    public MultiClickButton(ButtonState ... states) {
        this.setStates(states);
    }

    public MultiClickButton(ComponentClickListener<MultiClickButton> listener, ButtonState ... states) {
        this(states);
        this.addClickListener(listener);
    }

    @Override
    public Registration addClickListener(ComponentClickListener<MultiClickButton> listener) {
        return this.getEventBus().addListener(ComponentClickEvent.class, listener);
    }

    private void registerButtonClick(ClickEvent<Button> event) {
        if (this.states.size() > 1) {
            this.index = (this.index + 1) % this.states.size();
            this.updateButtonState(this.states.get(this.index));
        }
        if (this.index == 0) {
            this.fireEvent(new ComponentClickEvent<MultiClickButton>(this, new ClickEvent((Component)this, event.isFromClient(), event.getScreenX(), event.getScreenY(), event.getClientX(), event.getClientY(), event.getClickCount(), event.getButton(), event.isCtrlKey(), event.isShiftKey(), event.isAltKey(), event.isMetaKey())));
        }
    }

    protected void updateButtonState(ButtonState newState) {
        this.button.getClassNames().clear();
        this.button.getThemeNames().clear();
        this.button.setText(newState.getText());
        this.button.setIcon(newState.getIcon());
        this.button.addThemeNames(newState.getThemeNames().toArray(new String[0]));
        this.button.addThemeVariants((ThemeVariant[])newState.getThemeVariants().toArray(new ButtonVariant[0]));
        this.button.addClassNames(newState.getClassNames().toArray(new String[0]));
        this.fireEvent(new StateChangeEvent<ButtonState, MultiClickButton>(this, false, this.getState()));
    }

    public void setStates(Collection<ButtonState> states) {
        this.clear();
        this.states.addAll(states);
        if (!this.states.isEmpty()) {
            this.updateButtonState(this.states.get(0));
        }
    }

    public final void setStates(ButtonState ... states) {
        this.setStates(Arrays.asList(states));
    }

    public String getText() {
        return this.button.getText();
    }

    public Component getIcon() {
        return this.button.getIcon();
    }

    @Override
    public ButtonState getState() {
        return this.states.isEmpty() ? ButtonState.of(this.button) : this.states.get(this.index);
    }

    public void clear() {
        this.states.clear();
        this.index = 0;
        this.button.setText("");
        this.button.setIcon(null);
        this.button.getClassNames().clear();
    }

    protected Button initContent() {
        this.button.setSizeFull();
        this.button.addClassName("multi-click-inner-button");
        return this.button;
    }

    @Override
    public void click() {
        this.button.click();
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    @Override
    public Registration addStateChangeListener(StateChangeListener<ButtonState, MultiClickButton> listener) {
        return this.getEventBus().addListener(StateChangeEvent.class, listener);
    }
}

