/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.buttons;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.ButtonVariant;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.miki.markers.WithComponentAsIconMixin;
import org.vaadin.miki.markers.WithTextMixin;
import org.vaadin.miki.superfields.buttons.ButtonState;

public class SimpleButtonState
implements ButtonState,
WithComponentAsIconMixin<SimpleButtonState>,
WithTextMixin<SimpleButtonState> {
    private static final long serialVersionUID = 20200708L;
    private String text;
    private Component icon;
    private final Set<String> classNames = new LinkedHashSet<String>();
    private final Set<String> themeNames = new LinkedHashSet<String>();
    private final Set<ButtonVariant> themeVariants = new LinkedHashSet<ButtonVariant>();

    public static List<ButtonState> forTexts(String ... texts) {
        return Stream.of(texts).map(x$0 -> new SimpleButtonState((String)x$0, new String[0])).collect(Collectors.toList());
    }

    public SimpleButtonState() {
        this(null, (Component)null, new String[0]);
    }

    public SimpleButtonState(String text, String ... classNames) {
        this(text, (Component)null, classNames);
    }

    public SimpleButtonState(Component icon, String ... classNames) {
        this(null, icon, classNames);
    }

    public SimpleButtonState(String text, Component icon, String ... classNames) {
        this.setText(text);
        this.setIcon(icon);
        this.classNames.addAll(Arrays.asList(classNames));
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Component getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Component icon) {
        this.icon = icon;
    }

    public void addClassName(String ... classNames) {
        this.classNames.addAll(Arrays.asList(classNames));
    }

    public void removeClassName(String ... classNames) {
        Arrays.asList(classNames).forEach(this.classNames::remove);
    }

    @Override
    public Set<String> getClassNames() {
        return this.classNames;
    }

    public SimpleButtonState withClassName(String ... classNames) {
        this.addClassName(classNames);
        return this;
    }

    public SimpleButtonState withoutClassName(String ... classNames) {
        this.removeClassName(classNames);
        return this;
    }

    public void addThemeName(String ... themeNames) {
        this.themeNames.addAll(Arrays.asList(themeNames));
    }

    public void removeThemeName(String ... themeNames) {
        Arrays.asList(themeNames).forEach(this.themeNames::remove);
    }

    @Override
    public Set<String> getThemeNames() {
        return this.themeNames;
    }

    public SimpleButtonState withThemeName(String ... themeNames) {
        this.addThemeName(themeNames);
        return this;
    }

    public SimpleButtonState withoutThemeName(String ... themeNames) {
        this.removeThemeName(themeNames);
        return this;
    }

    public void addThemeVariant(ButtonVariant ... variants) {
        this.themeVariants.addAll(Arrays.asList(variants));
    }

    public void removeThemeVariant(ButtonVariant ... variants) {
        Arrays.asList(variants).forEach(this.themeVariants::remove);
    }

    @Override
    public Set<ButtonVariant> getThemeVariants() {
        return this.themeVariants;
    }

    public SimpleButtonState withThemeVariant(ButtonVariant ... variants) {
        this.addThemeVariant(variants);
        return this;
    }

    public SimpleButtonState withoutThemeVariant(ButtonVariant ... variants) {
        this.removeThemeVariant(variants);
        return this;
    }

    public ButtonState copy() {
        return new SimpleButtonState(this.getText(), this.getIcon(), this.getClassNames().toArray(new String[0])).withThemeName(this.getThemeNames().toArray(new String[0])).withThemeVariant(this.getThemeVariants().toArray(new ButtonVariant[0]));
    }
}

