/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.dates;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.function.BiConsumer;
import org.vaadin.miki.markers.HasDatePattern;
import org.vaadin.miki.shared.dates.DatePattern;
import org.vaadin.miki.superfields.dates.HasSuperDatePickerI18N;

final class DatePatternDelegate<C extends Component & HasSuperDatePickerI18N>
implements Serializable {
    private static final long serialVersionUID = 20200506L;
    private static final Map<DatePattern.MonthDisplayMode, String> MONTH_DISPLAY_PATTERNS = Map.of(DatePattern.MonthDisplayMode.NAME, "mM", DatePattern.MonthDisplayMode.NUMBER, "_M", DatePattern.MonthDisplayMode.ZERO_PREFIXED_NUMBER, "0M");
    private static final Map<DatePattern.Order, BiConsumer<StringBuilder, String[]>> ORDER_BUILDERS = Map.of(DatePattern.Order.DAY_MONTH_YEAR, (builder, strings) -> builder.append(strings[2]).append(strings[1]).append(strings[0]), DatePattern.Order.MONTH_DAY_YEAR, (builder, strings) -> builder.append(strings[1]).append(strings[2]).append(strings[0]), DatePattern.Order.YEAR_MONTH_DAY, (builder, strings) -> builder.append(strings[0]).append(strings[1]).append(strings[2]));
    private final C source;

    private static String convertDatePatternToClientPattern(DatePattern pattern) {
        if (pattern == null) {
            return null;
        }
        String dayPart = pattern.isZeroPrefixedDay() ? "0d" : "_d";
        String monthPart = MONTH_DISPLAY_PATTERNS.get((Object)pattern.getMonthDisplayMode());
        String yearPart = pattern.isShortYear() ? "0y" : "_y";
        StringBuilder builder = new StringBuilder();
        if (pattern.hasSeparator()) {
            builder.append(pattern.getSeparator());
        }
        ORDER_BUILDERS.get((Object)pattern.getDisplayOrder()).accept(builder, new String[]{yearPart, monthPart, dayPart});
        if (pattern.isShortYear() || pattern.isShortYearAlwaysAccepted()) {
            builder.append(pattern.isPreviousCenturyBelowBoundary() ? (char)'+' : '-');
            builder.append(String.format("%02d", pattern.getBaseCentury() % 100));
            builder.append(String.format("%02d", pattern.getCenturyBoundaryYear() % 100));
        }
        return builder.toString();
    }

    DatePatternDelegate(C source) {
        this.source = source;
        this.source.addAttachListener(this::onAttached);
    }

    void initPatternSetting() {
        this.source.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.source, (SerializableConsumer & Serializable)context -> this.source.getElement().callJsFunction("initPatternSetting", new Serializable[]{this.source})));
    }

    void onAttached(AttachEvent event) {
        this.initPatternSetting();
        this.updateClientSidePattern();
    }

    void updateClientSidePattern() {
        this.source.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.source, (SerializableConsumer & Serializable)context -> this.source.getElement().callJsFunction("setDisplayPattern", new Serializable[]{this.source.getElement(), DatePatternDelegate.convertDatePatternToClientPattern(((HasDatePattern)this.source).getDatePattern())})));
    }

    private int[] getDayMonthYearPositions(DatePattern.Order order) {
        if (order == DatePattern.Order.DAY_MONTH_YEAR) {
            return new int[]{0, 1, 2};
        }
        if (order == DatePattern.Order.MONTH_DAY_YEAR) {
            return new int[]{1, 0, 2};
        }
        return new int[]{2, 1, 0};
    }

    String formatDate(LocalDate date) {
        DatePattern pattern = ((HasDatePattern)this.source).getDatePattern();
        CharSequence[] parts = new String[3];
        int[] indices = this.getDayMonthYearPositions(pattern.getDisplayOrder());
        parts[indices[0]] = pattern.isZeroPrefixedDay() ? String.format("%02d", date.getDayOfMonth()) : String.valueOf(date.getDayOfMonth());
        switch (pattern.getMonthDisplayMode()) {
            case ZERO_PREFIXED_NUMBER: {
                parts[indices[1]] = String.format("%02d", date.getMonthValue());
                break;
            }
            case NAME: {
                parts[indices[1]] = ((HasSuperDatePickerI18N)this.source).getSuperDatePickerI18n().getDisplayMonthNames().get(date.getMonthValue() - 1);
                break;
            }
            default: {
                parts[indices[1]] = String.valueOf(date.getMonthValue());
            }
        }
        parts[indices[2]] = pattern.isShortYear() ? String.format("%02d", date.getYear() % 100) : String.valueOf(date.getYear());
        return String.join((CharSequence)String.valueOf(pattern.getSeparator()), parts);
    }
}

