/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.gridselect;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithItemsMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithMaximumSelectionSizeMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.gridselect.AbstractGridSelect;
import org.vaadin.miki.superfields.gridselect.RestrictedModeGrid;

public class GridMultiSelect<V>
extends AbstractGridSelect<V, Set<V>>
implements WithIdMixin<GridMultiSelect<V>>,
WithItemsMixin<V, GridMultiSelect<V>>,
WithMaximumSelectionSizeMixin<GridMultiSelect<V>>,
WithHelperMixin<GridMultiSelect<V>>,
WithHelperPositionableMixin<GridMultiSelect<V>>,
WithLabelPositionableMixin<GridMultiSelect<V>>,
WithLabelMixin<GridMultiSelect<V>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<Set<V>>, Set<V>>, Set<V>, GridMultiSelect<V>> {
    private int maximumSelectionSize = 0;
    private boolean doNotUpdateValue;

    @SafeVarargs
    public GridMultiSelect(V ... items) {
        super(new RestrictedModeGrid(Grid.SelectionMode.MULTI));
        this.setItems(items);
    }

    @SafeVarargs
    public GridMultiSelect(Class<V> type, boolean createColumns, V ... items) {
        super(new RestrictedModeGrid<V>(type, createColumns, Grid.SelectionMode.MULTI));
        this.setItems(items);
    }

    protected GridMultiSelect(Grid<V> underlyingGrid) {
        super(underlyingGrid);
    }

    @Override
    protected void onGridSelected(SelectionEvent<Grid<V>, V> event) {
        boolean bl = this.doNotUpdateValue = this.getMaximumSelectionSize() > 0 && event.getAllSelectedItems().size() > this.getMaximumSelectionSize();
        if (!this.doNotUpdateValue) {
            super.onGridSelected(event);
        }
    }

    @Override
    protected void configureGrid(Grid<V> grid) {
        super.configureGrid(grid);
        grid.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)grid, (SerializableConsumer & Serializable)context -> grid.getElement().executeJs("$0.addEventListener('selected-items-changed', (e) => {const {target: grid} = e;if (grid.selectedItems.length > grid.maximumSelectionSize && grid.maximumSelectionSize > 0) {console.log('GMS: preventing selection, limit reached'); console.log('GMS: selected '+grid.selectedItems.length+' - limit '+grid.maximumSelectionSize); e.stopPropagation();grid.splice('selectedItems', -1);console.log('GMS: selected items are '+JSON.stringify(grid.selectedItems)); }});", new Serializable[0])));
    }

    protected Set<V> generateModelValue() {
        return this.getGrid().getSelectedItems();
    }

    protected void updateValue() {
        if (!this.doNotUpdateValue) {
            super.updateValue();
        } else {
            Set value = (Set)super.getValue();
            this.getGrid().getSelectedItems().stream().filter(v -> value == null || !value.contains(v)).forEach(v -> this.getGrid().getSelectionModel().deselect(v));
        }
    }

    protected void setPresentationValue(Set<V> vs) {
        this.getGrid().asMultiSelect().updateSelection(vs, this.getGrid().getSelectedItems());
    }

    public void setItems(Collection<V> collection) {
        this.getGrid().setItems(collection);
    }

    @Override
    public void setMaximumSelectionSize(int maximumSelectionSize) {
        this.maximumSelectionSize = maximumSelectionSize;
        this.getGrid().getElement().setProperty("maximumSelectionSize", (double)maximumSelectionSize);
        if (maximumSelectionSize > 0 && this.getGrid().getSelectedItems().size() > maximumSelectionSize) {
            this.setValue(Collections.emptySet());
        }
        ((GridMultiSelectionModel)this.getGrid().getSelectionModel()).setSelectAllCheckboxVisibility(maximumSelectionSize <= 0 ? GridMultiSelectionModel.SelectAllCheckboxVisibility.VISIBLE : GridMultiSelectionModel.SelectAllCheckboxVisibility.HIDDEN);
    }

    @Override
    public int getMaximumSelectionSize() {
        return this.maximumSelectionSize;
    }
}

