/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.itemgrid;

import org.vaadin.miki.superfields.itemgrid.RowPadding;
import org.vaadin.miki.superfields.itemgrid.RowPaddingStrategy;

public final class RowPaddingStrategies {
    public static final RowPaddingStrategy NO_PADDING = (rowNumber, gridColumns, itemsLeft) -> RowPadding.NONE;
    public static final RowPaddingStrategy LAST_ROW_FILL_END = (rowNumber, gridColumns, itemsLeft) -> itemsLeft >= gridColumns ? RowPadding.NONE : new RowPadding(0, gridColumns - itemsLeft);
    public static final RowPaddingStrategy LAST_ROW_FILL_BEGINNING = (rowNumber, gridColumns, itemsLeft) -> itemsLeft >= gridColumns ? RowPadding.NONE : new RowPadding(gridColumns - itemsLeft, 0);
    public static final RowPaddingStrategy LAST_ROW_CENTRE_BEGINNING = (rowNumber, gridColumns, itemsLeft) -> itemsLeft >= gridColumns ? RowPadding.NONE : RowPadding.centred(itemsLeft, gridColumns, true);
    public static final RowPaddingStrategy LAST_ROW_CENTRE_END = (rowNumber, gridColumns, itemsLeft) -> itemsLeft >= gridColumns ? RowPadding.NONE : RowPadding.centred(itemsLeft, gridColumns, false);
    public static final RowPaddingStrategy FIRST_ROW_FILL_END = (rowNumber, gridColumns, itemsLeft) -> rowNumber == 0 ? new RowPadding(0, gridColumns - itemsLeft % gridColumns) : RowPadding.NONE;
    public static final RowPaddingStrategy FIRST_ROW_FILL_BEGINNING = (rowNumber, gridColumns, itemsLeft) -> rowNumber == 0 ? new RowPadding(gridColumns - itemsLeft % gridColumns, 0) : RowPadding.NONE;

    private RowPaddingStrategies() {
    }
}

