/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.layouts;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasComponents;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.vaadin.miki.markers.HasReadOnly;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.superfields.layouts.WithFooterComponentsMixin;
import org.vaadin.miki.superfields.layouts.WithHeaderComponentsMixin;

public class HeaderFooterLayoutWrapper<R extends Component, H extends Component, B extends Component, F extends Component>
extends Composite<R>
implements HasComponents,
Iterable<Component>,
WithHeaderComponentsMixin<H, HeaderFooterLayoutWrapper<R, H, B, F>>,
WithIdMixin<HeaderFooterLayoutWrapper<R, H, B, F>>,
WithFooterComponentsMixin<F, HeaderFooterLayoutWrapper<R, H, B, F>>,
HasReadOnly {
    private final R root;
    private final H header;
    private final B body;
    private final F footer;
    private boolean readOnly = false;

    public HeaderFooterLayoutWrapper(Supplier<R> rootSupplier, H header, B body, F footer) {
        this.root = (Component)rootSupplier.get();
        this.header = header;
        this.body = body;
        this.footer = footer;
        ((HasComponents)this.root).add(new Component[]{header, body, footer});
    }

    protected R initContent() {
        return this.root;
    }

    private void ensureReadOnly(Component ... components) {
        if (this.isReadOnly()) {
            for (Component component : components) {
                HasReadOnly.setReadOnly(true, component);
            }
        }
    }

    public void add(Component ... components) {
        this.ensureReadOnly(components);
        ((HasComponents)this.body).add(components);
    }

    public void addComponentAtIndex(int index, Component component) {
        this.ensureReadOnly(component);
        ((HasComponents)this.body).addComponentAtIndex(index, component);
    }

    public void removeAll() {
        ((HasComponents)this.body).removeAll();
    }

    public void remove(Component ... components) {
        ((HasComponents)this.body).remove(components);
    }

    @Override
    public Optional<H> getHeader() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public Optional<F> getFooter() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public Iterator<Component> iterator() {
        return this.getChildren().iterator();
    }

    public B getBody() {
        return this.body;
    }

    public Stream<Component> getComponents() {
        return this.body.getChildren();
    }

    private void forwardReadOnly(boolean state, Stream<Component> components) {
        components.forEach(component -> HasReadOnly.setReadOnly(state, component));
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        Stream.of(this.getHeader(), this.getFooter()).filter(Optional::isPresent).map(Optional::get).map(rec$ -> ((Component)rec$).getChildren()).forEach(stream -> this.forwardReadOnly(readOnly, (Stream<Component>)stream));
        this.forwardReadOnly(readOnly, this.getComponents());
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

