/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.text;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import org.vaadin.miki.events.text.TextSelectionListener;
import org.vaadin.miki.events.text.TextSelectionNotifier;
import org.vaadin.miki.markers.CanModifyText;
import org.vaadin.miki.markers.CanSelectText;
import org.vaadin.miki.markers.WithClearButtonMixin;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithInvalidInputPreventionMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithPlaceholderMixin;
import org.vaadin.miki.markers.WithReceivingSelectionEventsFromClientMixin;
import org.vaadin.miki.markers.WithRequiredMixin;
import org.vaadin.miki.markers.WithTextInputModeMixin;
import org.vaadin.miki.markers.WithTooltipMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.shared.text.TextInputMode;
import org.vaadin.miki.shared.text.TextModificationDelegate;

@Tag(value="super-text-field")
@JsModule(value="./super-text-field.js")
@CssImport(value="./styles/label-positions.css", themeFor="super-text-field")
public class SuperTextField
extends TextField
implements CanSelectText,
TextSelectionNotifier<SuperTextField>,
CanModifyText,
WithRequiredMixin<SuperTextField>,
WithLabelPositionableMixin<SuperTextField>,
WithIdMixin<SuperTextField>,
WithLabelMixin<SuperTextField>,
WithPlaceholderMixin<SuperTextField>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<TextField, String>, String, SuperTextField>,
WithHelperMixin<SuperTextField>,
WithHelperPositionableMixin<SuperTextField>,
WithReceivingSelectionEventsFromClientMixin<SuperTextField>,
WithClearButtonMixin<SuperTextField>,
WithTooltipMixin<SuperTextField>,
WithTextInputModeMixin<SuperTextField>,
WithInvalidInputPreventionMixin<SuperTextField> {
    private final TextModificationDelegate<SuperTextField> delegate;
    private TextInputMode textInputMode;
    private boolean preventInvalidInput;

    public SuperTextField() {
        this.delegate = new TextModificationDelegate<SuperTextField>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)() -> ((SuperTextField)this).getValue()));
    }

    public SuperTextField(String label) {
        super(label);
        this.delegate = new TextModificationDelegate<SuperTextField>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)() -> ((SuperTextField)this).getValue()));
    }

    public SuperTextField(String label, String placeholder) {
        super(label, placeholder);
        this.delegate = new TextModificationDelegate<SuperTextField>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)() -> ((SuperTextField)this).getValue()));
    }

    public SuperTextField(String label, String initialValue, String placeholder) {
        super(label, initialValue, placeholder);
        this.delegate = new TextModificationDelegate<SuperTextField>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)() -> ((SuperTextField)this).getValue()));
    }

    public SuperTextField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        super(listener);
        this.delegate = new TextModificationDelegate<SuperTextField>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)() -> ((SuperTextField)this).getValue()));
    }

    public SuperTextField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        super(label, listener);
        this.delegate = new TextModificationDelegate<SuperTextField>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)() -> ((SuperTextField)this).getValue()));
    }

    public SuperTextField(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        super(label, initialValue, listener);
        this.delegate = new TextModificationDelegate<SuperTextField>(this, this.getEventBus(), (SerializableSupplier<String>)((SerializableSupplier & Serializable)() -> ((SuperTextField)this).getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.delegate.onAttach(attachEvent, x$0 -> super.onAttach(x$0));
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.delegate.onDetach(detachEvent, x$0 -> super.onDetach(x$0));
    }

    @Override
    public Registration addTextSelectionListener(TextSelectionListener<SuperTextField> listener) {
        return this.delegate.addTextSelectionListener(listener);
    }

    @Override
    public void selectAll() {
        this.delegate.selectAll();
    }

    @Override
    public void selectNone() {
        this.delegate.selectNone();
    }

    @Override
    public void select(int from, int to) {
        this.delegate.select(from, to);
    }

    @ClientCallable
    private void selectionChanged(int start, int end, String selection) {
        this.delegate.fireTextSelectionEvent(true, start, end, selection);
    }

    @ClientCallable
    private void reinitialiseListening() {
        this.delegate.reinitialiseListeners();
    }

    @Override
    public boolean isReceivingSelectionEventsFromClient() {
        return this.delegate.isReceivingSelectionEventsFromClient();
    }

    @Override
    public void setReceivingSelectionEventsFromClient(boolean receivingSelectionEventsFromClient) {
        this.delegate.setReceivingSelectionEventsFromClient(receivingSelectionEventsFromClient);
    }

    @Override
    public void modifyText(String replacement, int from, int to) {
        this.delegate.modifyText(replacement, from, to);
    }

    @Override
    public void setTextInputMode(TextInputMode inputMode) {
        if (!Objects.equals((Object)inputMode, (Object)this.getTextInputMode())) {
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                if (inputMode != null) {
                    this.getElement().executeJs("this.inputElement.inputMode = $0;", new Serializable[]{inputMode.name().toLowerCase()});
                } else {
                    this.getElement().executeJs("delete this.inputElement.inputMode;", new Serializable[0]);
                }
                this.textInputMode = inputMode;
            }));
        }
    }

    @Override
    public TextInputMode getTextInputMode() {
        return this.textInputMode;
    }

    @Override
    public void setPreventingInvalidInput(boolean prevent) {
        this.preventInvalidInput = prevent;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.getElement().callJsFunction("preventInvalidInput", new Serializable[]{Boolean.valueOf(prevent)})));
    }

    @Override
    public boolean isPreventingInvalidInput() {
        return this.preventInvalidInput;
    }

    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public boolean isClearButtonVisible() {
        return super.isClearButtonVisible();
    }
}

