/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.shared.dates;

import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatePattern
implements Serializable {
    private static final long serialVersionUID = 20200423L;
    public static final char NO_SEPARATOR = '\u0000';
    public static final char DEFAULT_SEPARATOR = '-';
    private static final Logger LOGGER = LoggerFactory.getLogger(DatePattern.class);
    private final String displayName;
    private char separator = (char)45;
    private boolean zeroPrefixedDay = true;
    private MonthDisplayMode monthDisplayMode = MonthDisplayMode.ZERO_PREFIXED_NUMBER;
    private boolean shortYear = false;
    private int baseCentury = 21;
    private int centuryBoundaryYear = 40;
    private boolean previousCenturyBelowBoundary = false;
    private boolean shortYearAlwaysAccepted = false;
    private Order displayOrder = Order.YEAR_MONTH_DAY;

    public DatePattern() {
        this(null);
    }

    public DatePattern(String string) {
        this.displayName = string;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean hasSeparator() {
        return this.getSeparator() != '\u0000';
    }

    public void setSeparator(char separator) {
        this.separator = separator;
        if (separator == '\u0000') {
            this.withZeroPrefixedDay(true).setMonthDisplayMode(MonthDisplayMode.ZERO_PREFIXED_NUMBER);
            LOGGER.warn("disabling date pattern separator, turning on zero-prefixed day and zero-prefixed month");
        }
    }

    public DatePattern withSeparator(char separator) {
        this.setSeparator(separator);
        return this;
    }

    public DatePattern withoutSeparator() {
        return this.withSeparator('\u0000');
    }

    public boolean isZeroPrefixedDay() {
        return this.zeroPrefixedDay;
    }

    public void setZeroPrefixedDay(boolean zeroPrefixedDay) {
        this.zeroPrefixedDay = zeroPrefixedDay;
        if (!zeroPrefixedDay && !this.hasSeparator()) {
            this.setSeparator('-');
            LOGGER.warn("turning off zero-prefixed day requires a separator, setting it to be the default one ({})", (Object)Character.valueOf('-'));
        }
    }

    public DatePattern withZeroPrefixedDay(boolean zeroPrefixedDay) {
        this.setZeroPrefixedDay(zeroPrefixedDay);
        return this;
    }

    public void setMonthDisplayMode(MonthDisplayMode monthDisplayMode) {
        this.monthDisplayMode = monthDisplayMode;
        if (monthDisplayMode != MonthDisplayMode.ZERO_PREFIXED_NUMBER && !this.hasSeparator()) {
            this.setSeparator('-');
            LOGGER.warn("turning off zero-prefixed month requires a separator, setting it to be the default one ({})", (Object)Character.valueOf('-'));
        }
    }

    public MonthDisplayMode getMonthDisplayMode() {
        return this.monthDisplayMode;
    }

    public DatePattern withMonthDisplayMode(MonthDisplayMode monthDisplayMode) {
        this.setMonthDisplayMode(monthDisplayMode);
        return this;
    }

    public boolean isShortYear() {
        return this.shortYear;
    }

    public void setShortYear(boolean shortYear) {
        this.shortYear = shortYear;
    }

    public DatePattern withShortYear(boolean shortYear) {
        this.setShortYear(shortYear);
        return this;
    }

    public int getBaseCentury() {
        return this.baseCentury;
    }

    public void setBaseCentury(int baseCentury) {
        this.baseCentury = baseCentury;
    }

    public DatePattern withBaseCentury(int baseCentury) {
        this.setBaseCentury(baseCentury);
        return this;
    }

    public Order getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(Order displayOrder) {
        this.displayOrder = displayOrder;
    }

    public DatePattern withDisplayOrder(Order displayOrder) {
        this.setDisplayOrder(displayOrder);
        return this;
    }

    public int getCenturyBoundaryYear() {
        return this.centuryBoundaryYear;
    }

    public void setCenturyBoundaryYear(int centuryBoundaryYear) {
        this.centuryBoundaryYear = Math.abs(centuryBoundaryYear) % 100;
    }

    public DatePattern withCenturyBoundaryYear(int centuryBoundaryYear) {
        this.setCenturyBoundaryYear(centuryBoundaryYear);
        return this;
    }

    public boolean isPreviousCenturyBelowBoundary() {
        return this.previousCenturyBelowBoundary;
    }

    public void setPreviousCenturyBelowBoundary(boolean previousCenturyBelowBoundary) {
        this.previousCenturyBelowBoundary = previousCenturyBelowBoundary;
    }

    public DatePattern withPreviousCenturyBelowBoundary(boolean belowBoundaryIsPreviousCentury) {
        this.setPreviousCenturyBelowBoundary(belowBoundaryIsPreviousCentury);
        return this;
    }

    public void setShortYearAlwaysAccepted(boolean shortYearAlwaysAccepted) {
        this.shortYearAlwaysAccepted = shortYearAlwaysAccepted;
    }

    public boolean isShortYearAlwaysAccepted() {
        return this.shortYearAlwaysAccepted;
    }

    public DatePattern withShortYearAlwaysAccepted(boolean shortYearAlwaysAccepted) {
        this.setShortYearAlwaysAccepted(shortYearAlwaysAccepted);
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatePattern pattern = (DatePattern)o;
        return this.getSeparator() == pattern.getSeparator() && this.isZeroPrefixedDay() == pattern.isZeroPrefixedDay() && this.getMonthDisplayMode() == pattern.getMonthDisplayMode() && this.isShortYear() == pattern.isShortYear() && this.getBaseCentury() == pattern.getBaseCentury() && this.getCenturyBoundaryYear() == pattern.getCenturyBoundaryYear() && this.isPreviousCenturyBelowBoundary() == pattern.isPreviousCenturyBelowBoundary() && this.isShortYearAlwaysAccepted() == pattern.isShortYearAlwaysAccepted() && this.getDisplayOrder() == pattern.getDisplayOrder();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Character.valueOf(this.getSeparator()), this.isZeroPrefixedDay(), this.getMonthDisplayMode(), this.isShortYear(), this.getBaseCentury(), this.getCenturyBoundaryYear(), this.isPreviousCenturyBelowBoundary(), this.isShortYearAlwaysAccepted(), this.getDisplayOrder()});
    }

    public String toString() {
        return this.getDisplayName() == null ? "DatePattern{separator=" + this.separator + ", zeroPrefixedDay=" + this.zeroPrefixedDay + ", monthDisplayMode=" + (Object)((Object)this.monthDisplayMode) + ", shortYear=" + this.shortYear + ", baseCentury=" + this.baseCentury + ", centuryBoundaryYear=" + this.centuryBoundaryYear + ", previousCenturyBelowBoundary=" + this.previousCenturyBelowBoundary + ", shortYearAlwaysAccepted=" + this.shortYearAlwaysAccepted + ", displayOrder=" + (Object)((Object)this.displayOrder) + '}' : this.getDisplayName();
    }

    public static enum MonthDisplayMode {
        ZERO_PREFIXED_NUMBER,
        NUMBER,
        NAME;

    }

    public static enum Order {
        DAY_MONTH_YEAR,
        MONTH_DAY_YEAR,
        YEAR_MONTH_DAY;

    }
}

