/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.shared.text;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.events.text.TextSelectionEvent;
import org.vaadin.miki.events.text.TextSelectionListener;
import org.vaadin.miki.events.text.TextSelectionNotifier;
import org.vaadin.miki.markers.CanReceiveSelectionEventsFromClient;
import org.vaadin.miki.markers.CanSelectText;

public class TextSelectionDelegate<C extends Component & CanReceiveSelectionEventsFromClient>
implements Serializable,
CanSelectText,
CanReceiveSelectionEventsFromClient,
TextSelectionNotifier<C> {
    public static final String SELECTED_TEXT_ATTRIBUTE_NAME = "data-selected-text";
    private static final int MAX_REINITIALISING_ATTEMPTS = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(TextSelectionDelegate.class);
    private final C source;
    private final Element sourceElement;
    private final ComponentEventBus eventBus;
    private final SerializableSupplier<String> stringValueSupplier;
    private boolean receivingSelectionEventsFromClient = false;
    private int reinitialisationAttemptsLeft = 3;

    public TextSelectionDelegate(C source, ComponentEventBus eventBus, SerializableSupplier<String> stringValueSupplier) {
        this.source = source;
        this.sourceElement = source.getElement();
        this.eventBus = eventBus;
        this.stringValueSupplier = stringValueSupplier;
        if (source instanceof HasValue) {
            ((HasValue)source).addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.clearSelectionOnValueChange());
        }
    }

    protected final C getSource() {
        return this.source;
    }

    protected final Element getSourceElement() {
        return this.sourceElement;
    }

    public void informClientAboutSendingEvents(boolean value) {
        this.sourceElement.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.source, (SerializableConsumer & Serializable)context -> this.sourceElement.callJsFunction("setCallingServer", new Serializable[]{Boolean.valueOf(value)})));
    }

    public void fireTextSelectionEvent(boolean fromClient, int start, int end, String text) {
        TextSelectionEvent<C> event = new TextSelectionEvent<C>(this.source, fromClient, start, end, text);
        this.eventBus.fireEvent(event);
    }

    @Override
    public void selectAll() {
        this.sourceElement.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.source, (SerializableConsumer & Serializable)context -> this.sourceElement.callJsFunction("selectAll", new Serializable[]{this.source.getElement()})));
        if (!this.isReceivingSelectionEventsFromClient()) {
            String value = (String)this.stringValueSupplier.get();
            this.sourceElement.setAttribute(SELECTED_TEXT_ATTRIBUTE_NAME, value);
            this.fireTextSelectionEvent(false, 0, value.length(), value);
        }
    }

    @Override
    public void selectNone() {
        this.sourceElement.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.source, (SerializableConsumer & Serializable)context -> this.sourceElement.callJsFunction("selectNone", new Serializable[]{this.source.getElement()})));
        if (!this.isReceivingSelectionEventsFromClient()) {
            this.sourceElement.setAttribute(SELECTED_TEXT_ATTRIBUTE_NAME, "");
            this.fireTextSelectionEvent(false, -1, -1, "");
        }
    }

    @Override
    public void select(int from, int to) {
        if (from <= to) {
            this.sourceElement.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.source, (SerializableConsumer & Serializable)context -> this.sourceElement.callJsFunction("select", new Serializable[]{this.source.getElement(), Integer.valueOf(from), Integer.valueOf(to)})));
        }
        if (!this.isReceivingSelectionEventsFromClient()) {
            String value = ((String)this.stringValueSupplier.get()).substring(from, to);
            this.sourceElement.setAttribute(SELECTED_TEXT_ATTRIBUTE_NAME, value);
            this.fireTextSelectionEvent(false, from, to, value);
        }
    }

    public void clearSelectionOnValueChange() {
        if (!this.isReceivingSelectionEventsFromClient()) {
            String lastSelected = Optional.ofNullable(this.sourceElement.getAttribute(SELECTED_TEXT_ATTRIBUTE_NAME)).orElse("");
            this.sourceElement.setAttribute(SELECTED_TEXT_ATTRIBUTE_NAME, "");
            if (!Objects.equals(lastSelected, "")) {
                this.fireTextSelectionEvent(false, -1, -1, "");
            }
        }
    }

    public void onAttach(AttachEvent event, Consumer<AttachEvent> originalMethod) {
        this.informClientAboutSendingEvents(this.isReceivingSelectionEventsFromClient());
        originalMethod.accept(event);
    }

    public void onDetach(DetachEvent event, Consumer<DetachEvent> originalMethod) {
        if (this.isReceivingSelectionEventsFromClient()) {
            this.informClientAboutSendingEvents(false);
        }
        originalMethod.accept(event);
    }

    @Override
    public Registration addTextSelectionListener(TextSelectionListener<C> listener) {
        return this.eventBus.addListener(TextSelectionEvent.class, listener);
    }

    @Override
    public boolean isReceivingSelectionEventsFromClient() {
        return this.receivingSelectionEventsFromClient;
    }

    @Override
    public void setReceivingSelectionEventsFromClient(boolean receivingSelectionEventsFromClient) {
        this.receivingSelectionEventsFromClient = receivingSelectionEventsFromClient;
        this.informClientAboutSendingEvents(receivingSelectionEventsFromClient);
    }

    public void reinitialiseListeners() {
        if (this.reinitialisationAttemptsLeft-- > 0) {
            this.informClientAboutSendingEvents(this.isReceivingSelectionEventsFromClient());
        } else {
            LOGGER.warn("failed {} init attempts for {} (perhaps it is used in GridPro?) - browser-initiated text selection events may not work correctly", (Object)3, (Object)this.source.getClass().getSimpleName());
        }
    }
}

