/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.buttons;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import org.vaadin.miki.markers.Clickable;
import org.vaadin.miki.markers.WithComponentAsIconMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithIndexMixin;
import org.vaadin.miki.markers.WithTextMixin;
import org.vaadin.miki.markers.WithTooltipMixin;

public class IndexedButton
extends Button
implements WithIndexMixin<IndexedButton>,
WithIdMixin<IndexedButton>,
WithComponentAsIconMixin<IndexedButton>,
WithTextMixin<IndexedButton>,
Clickable,
WithTooltipMixin<IndexedButton> {
    public static final int DEFAULT_INDEX = -1;
    private int index = -1;

    public IndexedButton() {
    }

    public IndexedButton(String text) {
        super(text);
    }

    public IndexedButton(Component icon) {
        super(icon);
    }

    public IndexedButton(String text, Component icon) {
        super(text, icon);
    }

    public IndexedButton(String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        super(text, clickListener);
    }

    public IndexedButton(Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        super(icon, clickListener);
    }

    public IndexedButton(String text, Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        super(text, icon, clickListener);
    }

    public IndexedButton(int startingIndex) {
        this.setIndex(startingIndex);
    }

    public IndexedButton(String text, int startingIndex, ComponentEventListener<ClickEvent<Button>> listener) {
        this(text, listener);
        this.setIndex(startingIndex);
    }

    public IndexedButton(String text, Component icon, int startingIndex, ComponentEventListener<ClickEvent<Button>> listener) {
        this(text, icon, listener);
        this.setIndex(startingIndex);
    }

    public IndexedButton(Component icon, int startingIndex, ComponentEventListener<ClickEvent<Button>> listener) {
        this(icon, listener);
        this.setIndex(startingIndex);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public final void setIndex(int index) {
        this.index = index;
        this.setEnabled(index > -1);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    public void setTooltipText(String title) {
        this.getElement().setProperty("title", title == null ? "" : title);
    }

    @Override
    public String getTooltipText() {
        String result = this.getElement().getProperty("title");
        return result == null ? "" : result;
    }
}

