/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.componentselect;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithItemsMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.componentselect.ComponentSelect;

public abstract class AbstractComponentSelect<C extends Component, T, I, SELF extends AbstractComponentSelect<C, T, I, SELF>>
extends CustomField<T>
implements HasStyle,
WithItemsMixin<I, SELF>,
WithIdMixin<SELF>,
WithLabelMixin<SELF>,
WithLabelPositionableMixin<SELF>,
WithHelperMixin<SELF>,
WithHelperPositionableMixin<SELF>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T, SELF> {
    public static final int NO_SELECTION = -1;
    private final List<I> options = new ArrayList<I>();
    private final List<C> components = new ArrayList<C>();
    private final HasComponents layout;
    private SerializableBiFunction<Integer, I, C> factory;
    private SerializableBiConsumer<Integer, C> whenSelected = AbstractComponentSelect.noOp();
    private SerializableBiConsumer<Integer, C> whenDeselected = AbstractComponentSelect.noOp();

    protected static <X, Y> SerializableBiConsumer<X, Y> noOp() {
        return (SerializableBiConsumer & Serializable)(x, y) -> {};
    }

    @SafeVarargs
    protected <L extends Component> AbstractComponentSelect(T defaultValue, Supplier<L> layoutSupplier, SerializableBiFunction<Integer, I, C> componentFactory, SerializableBiConsumer<Integer, C> selectionModifier, SerializableBiConsumer<Integer, C> deselectionModifier, I ... options) {
        super(defaultValue);
        this.layout = (HasComponents)layoutSupplier.get();
        this.setComponentFactory(componentFactory);
        this.setComponentSelectedAction(selectionModifier);
        this.setComponentDeselectedAction(deselectionModifier);
        this.add(new Component[]{(Component)this.layout});
        this.options.addAll(Arrays.asList(options));
        this.rebuildComponents(true);
    }

    protected abstract boolean isSelected(int var1);

    protected abstract boolean itemClicked(int var1);

    private void onComponentClicked(ClickEvent<C> event) {
        if (this.itemClicked(this.getComponentIndex(event.getSource()))) {
            this.updateValue();
        }
    }

    protected void deselect(int index) {
        this.ensureValidIndex(index);
        if (index != -1) {
            this.whenDeselected.accept((Object)index, this.components.get(index));
        }
    }

    protected void select(int index) {
        this.ensureValidIndex(index);
        if (index != -1) {
            this.whenSelected.accept((Object)index, this.components.get(index));
        }
    }

    private void rebuildComponents(boolean ignoreActions) {
        this.layout.removeAll();
        this.components.clear();
        int index = -1;
        for (I option : this.options) {
            Component component = (Component)this.getComponentFactory().apply((Object)(++index), option);
            ((ClickNotifier)component).addClickListener(this::onComponentClicked);
            if (!ignoreActions) {
                if (this.isSelected(index)) {
                    this.getComponentSelectedAction().accept((Object)index, (Object)component);
                } else {
                    this.getComponentDeselectedAction().accept((Object)index, (Object)component);
                }
            }
            this.components.add(component);
            this.layout.add(new Component[]{component});
        }
    }

    protected final void rebuildComponents() {
        this.rebuildComponents(false);
    }

    protected List<I> getOptions() {
        return this.options;
    }

    protected final int getComponentIndex(C component) {
        int result = -1;
        for (int zmp1 = 0; zmp1 < this.components.size() && result == -1; ++zmp1) {
            if (!Objects.equals(this.components.get(zmp1), component)) continue;
            result = zmp1;
        }
        return result;
    }

    protected void ensureValidIndex(int index) {
        if (index < -1 || index >= this.options.size()) {
            throw new IllegalArgumentException("incorrect index, expected 0 <= index < " + this.options.size());
        }
    }

    public final void setComponentFactory(SerializableBiFunction<Integer, I, C> factory) {
        this.factory = Objects.requireNonNull(factory);
        this.rebuildComponents();
    }

    public SerializableBiFunction<Integer, I, C> getComponentFactory() {
        return this.factory;
    }

    public final SELF withComponentFactory(SerializableBiFunction<Integer, I, C> factory) {
        this.setComponentFactory(factory);
        return (SELF)this;
    }

    public final void setComponentSelectedAction(SerializableBiConsumer<Integer, C> action) {
        this.whenSelected = action == null ? ComponentSelect.noOp() : action;
        this.rebuildComponents();
    }

    public SerializableBiConsumer<Integer, C> getComponentSelectedAction() {
        return this.whenSelected;
    }

    public final SELF withComponentSelectedAction(SerializableBiConsumer<Integer, C> action) {
        this.setComponentSelectedAction(action);
        return (SELF)this;
    }

    public final void setComponentDeselectedAction(SerializableBiConsumer<Integer, C> action) {
        this.whenDeselected = action == null ? ComponentSelect.noOp() : action;
        this.rebuildComponents();
    }

    public SerializableBiConsumer<Integer, C> getComponentDeselectedAction() {
        return this.whenDeselected;
    }

    public final SELF withComponentDeselectedAction(SerializableBiConsumer<Integer, C> action) {
        this.setComponentDeselectedAction(action);
        return (SELF)this;
    }

    public void setItems(Collection<I> items) {
        this.options.clear();
        this.options.addAll(items);
        this.rebuildComponents();
    }

    public void focus() {
        if (!this.components.isEmpty() && this.components.get(0) instanceof Focusable) {
            ((Focusable)this.components.get(0)).focus();
        } else {
            super.focus();
        }
    }

    C getComponent(int index) {
        this.ensureValidIndex(index);
        return (C)((Component)this.components.get(index));
    }

    int getComponentCount() {
        return this.components.size();
    }
}

