/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.componentselect;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ComponentSelectHelpers {
    public static <C extends Component & HasStyle> SerializableBiConsumer<Integer, C> changeStyle(String fromStyle, String toStyle) {
        return (SerializableBiConsumer & Serializable)(index, component) -> {
            if (fromStyle != null && !fromStyle.isEmpty()) {
                ((HasStyle)component).removeClassName(fromStyle);
            }
            if (toStyle != null && !toStyle.isEmpty()) {
                ((HasStyle)component).addClassName(toStyle);
            }
        };
    }

    public static <T, C extends Component & HasText> SerializableBiFunction<Integer, T, C> simpleComponentFactory(Supplier<C> constructor) {
        return ComponentSelectHelpers.simpleComponentFactory(constructor, Object::toString);
    }

    public static <T, C extends Component & HasText> SerializableBiFunction<Integer, T, C> simpleComponentFactory(Supplier<C> constructor, Function<T, String> captionGenerator) {
        return (SerializableBiFunction & Serializable)(index, t) -> {
            Component result = (Component)constructor.get();
            ((HasText)result).setText((String)captionGenerator.apply(t));
            return result;
        };
    }

    private ComponentSelectHelpers() {
    }
}

