/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.text;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableFunction;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithValueMixin;

@CssImport(value="./styles/label-positions-custom-field.css", themeFor="vaadin-custom-field")
@Tag(value="label-field")
@JsModule(value="./label-field.js")
public class LabelField<V>
extends CustomField<V>
implements HasStyle,
WithLabelMixin<LabelField<V>>,
WithHelperPositionableMixin<LabelField<V>>,
WithHelperMixin<LabelField<V>>,
WithLabelPositionableMixin<LabelField<V>>,
WithIdMixin<LabelField<V>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<V>, V>, V, LabelField<V>> {
    public static final String DEFAULT_NULL_REPRESENTATION = "";
    private final Text label = new Text("");
    private transient V value;
    private String nullRepresentation = "";
    private SerializableFunction<V, String> converter = Object::toString;

    public LabelField() {
        this.add(new Component[]{this.label});
    }

    protected V generateModelValue() {
        return this.value;
    }

    protected void setPresentationValue(V v) {
        this.value = v;
        this.label.setText(v == null ? this.getNullRepresentation() : (String)this.getConverter().apply(v));
    }

    public final String getNullRepresentation() {
        return this.nullRepresentation;
    }

    public final void setNullRepresentation(String nullRepresentation) {
        String string = this.nullRepresentation = nullRepresentation == null ? DEFAULT_NULL_REPRESENTATION : nullRepresentation;
        if (this.value == null) {
            this.label.setText(nullRepresentation);
        }
    }

    public final LabelField<V> withNullRepresentation(String nullRepresentation) {
        this.setNullRepresentation(nullRepresentation);
        return this;
    }

    public SerializableFunction<V, String> getConverter() {
        return this.converter == null ? Object::toString : this.converter;
    }

    public void setConverter(SerializableFunction<V, String> converter) {
        this.converter = converter;
        if (this.value != null) {
            this.label.setText((String)this.getConverter().apply(this.value));
        }
    }

    public final LabelField<V> withConverter(SerializableFunction<V, String> converter) {
        this.setConverter(converter);
        return this;
    }

    Text getText() {
        return this.label;
    }
}

