/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.IntStream;

public class RegexTools {
    public static final Set<Character> CHARACTERS_TO_ESCAPE_OUTSIDE_CHAR_SELECTOR = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('\\'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('|'))));
    public static final Set<Character> CHARACTERS_TO_ESCAPE_ONLY_IN_CHAR_SELECTOR = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('\\'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('*'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('|'))));

    private static String escape(char character) {
        return "\\" + character;
    }

    public static String escaped(char character) {
        return RegexTools.escaped(character, true);
    }

    public static String escaped(char character, boolean insideCharSelector) {
        if (insideCharSelector && CHARACTERS_TO_ESCAPE_ONLY_IN_CHAR_SELECTOR.contains(Character.valueOf(character)) || CHARACTERS_TO_ESCAPE_OUTSIDE_CHAR_SELECTOR.contains(Character.valueOf(character))) {
            return RegexTools.escape(character);
        }
        return String.valueOf(character);
    }

    public static StringBuilder characterSelector(StringBuilder builder, char mainCharacter, Collection<Character> alternatives) {
        if (alternatives == null) {
            return builder.append(RegexTools.escaped(mainCharacter, false));
        }
        alternatives = new LinkedHashSet<Character>(alternatives);
        alternatives.remove(Character.valueOf(mainCharacter));
        if (alternatives.isEmpty()) {
            return builder.append(RegexTools.escaped(mainCharacter, false));
        }
        builder.append("[").append(RegexTools.escaped(mainCharacter));
        alternatives.forEach(character -> builder.append(RegexTools.escaped(character.charValue(), true)));
        return builder.append("]");
    }

    public static String characterSelector(char mainCharacter, Collection<Character> alternatives) {
        return RegexTools.characterSelector(new StringBuilder(), mainCharacter, alternatives).toString();
    }

    public static String characterSelector(char main, char ... alternatives) {
        if (alternatives == null || alternatives.length == 0) {
            return RegexTools.characterSelector(main, Collections.emptySet());
        }
        return RegexTools.characterSelector(main, Arrays.asList(IntStream.range(0, alternatives.length).mapToObj(index -> Character.valueOf(alternatives[index])).toArray(Character[]::new)));
    }

    private RegexTools() {
    }
}

