/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.lazyload;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.superfields.lazyload.ComponentObservationEvent;
import org.vaadin.miki.superfields.lazyload.ComponentObservationListener;

@JsModule(value="./component-observer.js")
@Tag(value="component-observer")
public class ComponentObserver
extends Component
implements WithIdMixin<ComponentObserver> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentObserver.class);
    private final double[] ranges;
    private final Map<String, Component> observedComponents = new HashMap<String, Component>();
    private final Map<Component, Registration> observedDetachedListeners = new HashMap<Component, Registration>();
    private final Element rootElement;
    private final String rootMargin;
    private int sequence = 0;
    private boolean clientInitialised = false;

    public ComponentObserver(double ... visibilityRanges) {
        this(null, "0px", visibilityRanges);
    }

    public ComponentObserver(Component viewportRoot, String rootMargin, double ... visibilityRanges) {
        double[] dArray;
        if (visibilityRanges == null || visibilityRanges.length == 0) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 1.0;
        } else {
            dArray = visibilityRanges;
        }
        this.ranges = dArray;
        this.rootElement = viewportRoot == null ? null : viewportRoot.getElement();
        this.rootMargin = rootMargin;
        this.initClient();
    }

    protected void initClient() {
        if (!this.clientInitialised) {
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.getElement().callJsFunction("initObserver", new Serializable[]{this.rootElement, this.rootMargin, JsonSerializer.toJson((Object)this.ranges)})));
            this.observedComponents.forEach(this::observe);
            this.clientInitialised = true;
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.clientInitialised = false;
        super.onDetach(detachEvent);
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.initClient();
        super.onAttach(attachEvent);
    }

    @ClientCallable
    private void componentStatusChanged(String key, double range) {
        LOGGER.debug("component with key {} changed visibility range to {}", (Object)key, (Object)range);
        this.fireComponentObservationEvent(new ComponentObservationEvent(this, this.observedComponents.get(key), range));
    }

    protected void fireComponentObservationEvent(ComponentObservationEvent event) {
        this.getEventBus().fireEvent((ComponentEvent)event);
    }

    protected void observe(String indexString, Component component) {
        this.observedComponents.put(indexString, component);
        this.observedDetachedListeners.put(component, component.addDetachListener((ComponentEventListener & Serializable)event -> this.unobserve(event.getSource())));
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)executionContext -> this.getElement().callJsFunction("observe", new Serializable[]{component.getElement(), indexString})));
    }

    public void observe(Component ... components) {
        for (Component component : components) {
            if (this.observedComponents.containsValue(component)) continue;
            String indexString = "component-observer-" + this.sequence++;
            this.observe(indexString, component);
        }
    }

    public void unobserve(Component ... components) {
        for (Component component : components) {
            Optional<String> perhapsKey = this.observedComponents.entrySet().stream().filter(entry -> ((Component)entry.getValue()).equals(component)).findFirst().map(Map.Entry::getKey);
            perhapsKey.ifPresent(key -> {
                Component removed = this.observedComponents.remove(key);
                this.observedDetachedListeners.get(removed).remove();
                this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)executionContext -> this.getElement().callJsFunction("unobserve", new Serializable[]{removed.getElement()})));
            });
        }
    }

    public Registration addComponentObservationListener(ComponentObservationListener listener) {
        return this.getEventBus().addListener(ComponentObservationEvent.class, (ComponentEventListener)listener);
    }

    public boolean isObserving(Component component) {
        return this.observedComponents.containsValue(component);
    }

    public double[] getVisibilityRanges() {
        double[] result = new double[this.ranges.length];
        System.arraycopy(this.ranges, 0, result, 0, this.ranges.length);
        return result;
    }
}

