/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.collections;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.function.SerializableSupplier;
import java.util.Map;
import java.util.function.Supplier;
import org.vaadin.miki.superfields.layouts.FlexLayoutHelpers;
import org.vaadin.miki.superfields.text.LabelField;

@Tag(value="map-entry-field")
@JsModule(value="./map-entry-field.js")
public class MapEntryField<K, V>
extends CustomField<Map.Entry<K, V>> {
    public static final SerializableSupplier<FlexLayout> DEFAULT_LAYOUT_PROVIDER = FlexLayoutHelpers::row;
    private SerializableSupplier<HasValue<?, K>> keyComponentSupplier;
    private SerializableSupplier<HasValue<?, V>> valueComponentSupplier;
    private SerializableSupplier<HasComponents> layoutSupplier;
    private HasComponents layout;
    private HasValue<?, K> keyComponent;
    private HasValue<?, V> valueComponent;
    private boolean valueChangeInProgress = false;

    public <L extends Component, KC extends Component, VC extends Component> MapEntryField(SerializableSupplier<L> layoutSupplier, SerializableSupplier<KC> keyComponentSupplier, SerializableSupplier<VC> valueComponentSupplier) {
        this.layoutSupplier = layoutSupplier;
        this.keyComponentSupplier = keyComponentSupplier;
        this.valueComponentSupplier = valueComponentSupplier;
        this.repaintLayout();
        this.repaintComponents();
        this.updateValue();
    }

    public <KC extends Component, VC extends Component> MapEntryField(SerializableSupplier<KC> keyComponentSupplier, SerializableSupplier<VC> valueComponentSupplier) {
        this(DEFAULT_LAYOUT_PROVIDER, keyComponentSupplier, valueComponentSupplier);
    }

    public <L extends Component> MapEntryField(SerializableSupplier<L> layoutSupplier) {
        this(layoutSupplier, LabelField::new, LabelField::new);
    }

    public MapEntryField() {
        this(DEFAULT_LAYOUT_PROVIDER);
    }

    protected Map.Entry<K, V> generateModelValue() {
        if (this.keyComponent != null && this.valueComponent != null) {
            return Map.entry(this.keyComponent.getValue(), this.valueComponent.getValue());
        }
        return null;
    }

    private void repaintLayout() {
        if (this.layoutSupplier == null) {
            throw new IllegalStateException("cannot create layout, no supplier set! (call setLayoutSupplier() with a non-null value)");
        }
        this.removeComponentsFromLayout();
        if (this.layout != null) {
            this.remove(new Component[]{(Component)this.layout});
        }
        this.layout = (HasComponents)this.layoutSupplier.get();
        this.add(new Component[]{(Component)this.layout});
        if (this.keyComponent != null) {
            this.layout.add(new Component[]{(Component)this.keyComponent});
        }
        if (this.valueComponent != null) {
            this.layout.add(new Component[]{(Component)this.valueComponent});
        }
    }

    private void removeComponentsFromLayout() {
        if (this.keyComponent != null) {
            this.layout.remove(new Component[]{(Component)this.keyComponent});
        }
        if (this.valueComponent != null) {
            this.layout.remove(new Component[]{(Component)this.valueComponent});
        }
    }

    private void repaintComponents() {
        if (this.keyComponentSupplier == null) {
            throw new IllegalStateException("cannot create component for key, no supplier set! (call setKeyComponentSupplier() or use a proper constructor)");
        }
        if (this.valueComponentSupplier == null) {
            throw new IllegalStateException("cannot create component for value, no supplier set! (call setValueComponentSupplier() or use a proper constructor)");
        }
        this.removeComponentsFromLayout();
        this.keyComponent = (HasValue)this.keyComponentSupplier.get();
        this.keyComponent.addValueChangeListener(this::valueChangedInSubComponent);
        this.valueComponent = (HasValue)this.valueComponentSupplier.get();
        this.valueComponent.addValueChangeListener(this::valueChangedInSubComponent);
        this.layout.add(new Component[]{(Component)this.keyComponent, (Component)this.valueComponent});
        Map.Entry currentValue = (Map.Entry)this.getValue();
        if (currentValue != null) {
            this.keyComponent.setValue(currentValue.getKey());
            this.valueComponent.setValue(currentValue.getValue());
        }
    }

    private void valueChangedInSubComponent(HasValue.ValueChangeEvent<?> o) {
        if (!this.valueChangeInProgress) {
            this.updateValue();
        }
    }

    protected void setPresentationValue(Map.Entry<K, V> entry) {
        this.valueChangeInProgress = true;
        if (this.keyComponent == null || this.valueComponent == null) {
            this.repaintComponents();
        }
        this.keyComponent.setValue(entry.getKey());
        this.valueComponent.setValue(entry.getValue());
        this.valueChangeInProgress = false;
    }

    public <C extends Component> Supplier<C> getKeyComponentSupplier() {
        return this.keyComponentSupplier;
    }

    public <C extends Component> void setKeyComponentSupplier(SerializableSupplier<C> keyComponentSupplier) {
        this.keyComponentSupplier = keyComponentSupplier;
        this.repaintComponents();
    }

    public <C extends Component> Supplier<C> getValueComponentSupplier() {
        return this.valueComponentSupplier;
    }

    public <C extends Component> void setValueComponentSupplier(SerializableSupplier<C> valueComponentSupplier) {
        this.valueComponentSupplier = valueComponentSupplier;
        this.repaintComponents();
    }

    public <C extends Component> Supplier<C> getLayoutSupplier() {
        return this.layoutSupplier;
    }

    public <C extends Component> void setLayoutSupplier(SerializableSupplier<C> layoutSupplier) {
        this.layoutSupplier = layoutSupplier;
        this.repaintLayout();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.keyComponent != null) {
            this.keyComponent.setReadOnly(readOnly);
        }
        if (this.valueComponent != null) {
            this.valueComponent.setReadOnly(readOnly);
        }
    }
}

