/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.componentselect;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import java.util.Objects;
import java.util.function.Supplier;
import org.vaadin.miki.markers.WithNullValueOptionallyAllowedMixin;
import org.vaadin.miki.superfields.componentselect.AbstractComponentSelect;

@Tag(value="component-select")
@JsModule(value="./component-select.js")
public class ComponentSelect<C extends Component, T>
extends AbstractComponentSelect<C, T, T, ComponentSelect<C, T>>
implements WithNullValueOptionallyAllowedMixin<ComponentSelect<C, T>, AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T> {
    private boolean nullValueAllowed = true;
    private int selected = -1;

    @SafeVarargs
    public <L extends Component> ComponentSelect(Supplier<L> layoutSupplier, SerializableBiFunction<Integer, T, C> componentFactory, T ... options) {
        this(layoutSupplier, componentFactory, null, null, options);
    }

    @SafeVarargs
    public <L extends Component> ComponentSelect(Supplier<L> layoutSupplier, SerializableBiFunction<Integer, T, C> componentFactory, SerializableBiConsumer<Integer, C> selectionModifier, SerializableBiConsumer<Integer, C> deselectionModifier, T ... options) {
        super(null, layoutSupplier, componentFactory, selectionModifier, deselectionModifier, options);
    }

    private void deselectCurrent() {
        if (this.isSelected()) {
            this.deselect(this.getSelectedIndex());
        }
    }

    public boolean isSelected() {
        return this.getSelectedIndex() != -1;
    }

    @Override
    protected boolean isSelected(int index) {
        return this.getSelectedIndex() == index;
    }

    @Override
    protected boolean itemClicked(int index) {
        boolean isAlreadySelected = this.isSelected(index);
        if (isAlreadySelected && this.isNullValueAllowed()) {
            this.deselect(index);
            this.selected = -1;
            return true;
        }
        if (!isAlreadySelected) {
            this.deselectCurrent();
            this.select(index);
            this.selected = index;
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int index) {
        this.ensureValidIndex(index);
        this.itemClicked(index > -1 ? index : this.getSelectedIndex());
        this.updateValue();
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    protected T generateModelValue() {
        return this.getSelectedIndex() == -1 ? null : (T)this.getOptions().get(this.getSelectedIndex());
    }

    protected void setPresentationValue(T t) {
        int selection = -1;
        if (t != null) {
            for (int zmp1 = 0; zmp1 < this.getOptions().size() && selection == -1; ++zmp1) {
                if (!Objects.equals(t, this.getOptions().get(zmp1))) continue;
                selection = zmp1;
            }
        }
        this.setSelectedIndex(selection);
    }

    @Override
    public boolean isNullValueAllowed() {
        return this.nullValueAllowed;
    }

    @Override
    public void setNullValueAllowed(boolean allowingNullValue) {
        this.nullValueAllowed = allowingNullValue;
    }
}

