/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.events.text;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import java.util.Optional;

public final class TextSelectionEvent<T extends Component>
extends ComponentEvent<T> {
    public static final int NO_SELECTION = -1;
    private final int selectionStart;
    private final int selectionEnd;
    private final String selectedText;

    public TextSelectionEvent(T source, boolean fromClient, int selectionStart, int selectionEnd, String selectedText) {
        super(source, fromClient);
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        this.selectedText = Optional.ofNullable(selectedText).orElse("");
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public boolean isAnythingSelected() {
        return this.selectionStart != -1 && this.selectionEnd != this.selectionStart && !this.selectedText.isEmpty();
    }
}

