/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.componentselect;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.vaadin.miki.markers.WithMaximumSelectionSizeMixin;
import org.vaadin.miki.superfields.componentselect.AbstractComponentSelect;

@Tag(value="component-multi-select")
@JsModule(value="./component-multi-select.js")
public class ComponentMultiSelect<C extends Component, T>
extends AbstractComponentSelect<C, Set<T>, T, ComponentMultiSelect<C, T>>
implements WithMaximumSelectionSizeMixin<ComponentMultiSelect<C, T>> {
    private int maxSelectionSize = 0;
    private final Set<Integer> selection = new LinkedHashSet<Integer>();

    @SafeVarargs
    public <L extends Component> ComponentMultiSelect(Supplier<L> layoutSupplier, SerializableBiFunction<Integer, T, C> componentFactory, T ... options) {
        this(layoutSupplier, componentFactory, ComponentMultiSelect.noOp(), ComponentMultiSelect.noOp(), options);
    }

    @SafeVarargs
    public <L extends Component> ComponentMultiSelect(Supplier<L> layoutSupplier, SerializableBiFunction<Integer, T, C> componentFactory, SerializableBiConsumer<Integer, C> selectionModifier, SerializableBiConsumer<Integer, C> deselectionModifier, T ... options) {
        super(Collections.emptySet(), layoutSupplier, componentFactory, selectionModifier, deselectionModifier, options);
    }

    @Override
    protected boolean isSelected(int index) {
        return this.selection.contains(index);
    }

    @Override
    protected boolean itemClicked(int index) {
        boolean isAlreadySelected = this.isSelected(index);
        if (isAlreadySelected) {
            this.deselect(index);
            this.selection.remove(index);
            return true;
        }
        if (this.getMaximumSelectionSize() == 0 || this.selection.size() < this.getMaximumSelectionSize()) {
            this.select(index);
            this.selection.add(index);
            return true;
        }
        return false;
    }

    protected Set<T> generateModelValue() {
        return this.selection.stream().map(this.getOptions()::get).collect(Collectors.toSet());
    }

    protected void setPresentationValue(Set<T> newPresentationValue) {
        if (newPresentationValue == null) {
            newPresentationValue = Collections.emptySet();
        }
        this.selection.clear();
        for (int zmp1 = 0; zmp1 < this.getOptions().size(); ++zmp1) {
            if (newPresentationValue.contains(this.getOptions().get(zmp1)) && (this.getMaximumSelectionSize() == 0 || this.selection.size() < this.getMaximumSelectionSize())) {
                this.select(zmp1);
                this.selection.add(zmp1);
                continue;
            }
            this.deselect(zmp1);
        }
        this.updateValue();
    }

    @Override
    public void setMaximumSelectionSize(int maximumSelectionSize) {
        this.maxSelectionSize = Math.max(0, maximumSelectionSize);
        if (this.maxSelectionSize != 0) {
            while (this.maxSelectionSize < this.selection.size()) {
                int indexToDeselect = (Integer)this.selection.stream().findAny().get();
                this.deselect(indexToDeselect);
                this.selection.remove(indexToDeselect);
            }
            this.updateValue();
        }
    }

    @Override
    public int getMaximumSelectionSize() {
        return this.maxSelectionSize;
    }
}

