/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.gridselect;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;

public class RestrictedModeGrid<T>
extends Grid<T> {
    private final Grid.SelectionMode allowedSelectionMode;

    public RestrictedModeGrid() {
        this(Grid.SelectionMode.SINGLE);
    }

    public RestrictedModeGrid(Grid.SelectionMode allowedSelectionMode) {
        this.allowedSelectionMode = allowedSelectionMode;
        this.setSelectionMode(allowedSelectionMode);
    }

    public RestrictedModeGrid(int pageSize, Grid.SelectionMode allowedSelectionMode) {
        super(pageSize);
        this.allowedSelectionMode = allowedSelectionMode;
        this.setSelectionMode(allowedSelectionMode);
    }

    public RestrictedModeGrid(Class<T> beanType, boolean autoCreateColumns, Grid.SelectionMode allowedSelectionMode) {
        super(beanType, autoCreateColumns);
        this.allowedSelectionMode = allowedSelectionMode;
        this.setSelectionMode(allowedSelectionMode);
    }

    public RestrictedModeGrid(Class<T> beanType, boolean autoCreateColumns) {
        this(beanType, autoCreateColumns, Grid.SelectionMode.SINGLE);
    }

    public RestrictedModeGrid(Class<T> beanType, Grid.SelectionMode allowedSelectionMode) {
        this(beanType, true, allowedSelectionMode);
    }

    public final Grid.SelectionMode getAllowedSelectionMode() {
        return this.allowedSelectionMode;
    }

    public GridSelectionModel<T> setSelectionMode(Grid.SelectionMode selectionMode) {
        if (selectionMode == Grid.SelectionMode.NONE || selectionMode == this.getAllowedSelectionMode()) {
            return super.setSelectionMode(selectionMode);
        }
        throw new IllegalArgumentException("this grid only allows NONE or " + this.getAllowedSelectionMode().name() + " as selection modes, not " + selectionMode.name());
    }
}

