/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.lazyload;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Optional;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.superfields.lazyload.ComponentObservationEvent;
import org.vaadin.miki.superfields.lazyload.ComponentObserver;

public class LazyLoad<C extends Component>
extends Composite<LazyLoadElement>
implements WithIdMixin<LazyLoad<C>>,
HasStyle {
    public static final String EMPTY_CLASS_NAME = "lazy-load-empty";
    public static final String LOADED_CLASS_NAME = "lazy-loaded";
    private final SerializableSupplier<C> componentProvider;
    private final ComponentObserver observer;
    private final boolean onlyLoadedOnce;
    private C lazyLoadedContent = null;
    private double hiddenVisibilityRange = 0.0;
    private double shownVisibilityRange = 1.0;

    public LazyLoad(C contents) {
        this(contents, false);
    }

    public LazyLoad(SerializableSupplier<C> supplier) {
        this(supplier, false);
    }

    public LazyLoad(C contents, boolean removeOnHide) {
        this((SerializableSupplier<C>)(SerializableSupplier & Serializable)() -> contents, removeOnHide);
    }

    public LazyLoad(SerializableSupplier<C> supplier, boolean removeOnHide) {
        this(supplier, (SerializableSupplier<ComponentObserver>)(SerializableSupplier & Serializable)() -> new ComponentObserver(new double[0]), removeOnHide);
    }

    public LazyLoad(C contents, SerializableSupplier<ComponentObserver> observerSupplier) {
        this((SerializableSupplier & Serializable)() -> contents, observerSupplier, false);
    }

    public LazyLoad(SerializableSupplier<C> contentSupplier, SerializableSupplier<ComponentObserver> observerSupplier) {
        this(contentSupplier, observerSupplier, false);
    }

    public LazyLoad(SerializableSupplier<C> contentSupplier, SerializableSupplier<ComponentObserver> observerSupplier, boolean removeOnHide) {
        this.componentProvider = contentSupplier;
        this.onlyLoadedOnce = !removeOnHide;
        this.observer = (ComponentObserver)observerSupplier.get();
        ((LazyLoadElement)this.getContent()).addClassNames(new String[]{EMPTY_CLASS_NAME});
        ((LazyLoadElement)this.getContent()).add(new Component[]{this.observer});
        this.observer.addComponentObservationListener(this::onComponentObserved);
        this.observer.observe(new Component[]{this});
    }

    private void onComponentObserved(ComponentObservationEvent event) {
        if (event.getVisibilityRange() >= this.getContentShownVisibilityRange()) {
            this.onNowVisible();
            if (this.onlyLoadedOnce) {
                this.observer.unobserve(new Component[]{this});
            }
        } else if (event.getVisibilityRange() <= this.getContentHiddenVisibilityRange()) {
            this.onNowHidden();
        }
    }

    public double getContentHiddenVisibilityRange() {
        return this.hiddenVisibilityRange;
    }

    public double getContentShownVisibilityRange() {
        return this.shownVisibilityRange;
    }

    public void setContentVisibilityRanges(double hiddenOnOrBelow, double visibleOnOrAbove) {
        if (hiddenOnOrBelow < 0.0 || visibleOnOrAbove > 1.0) {
            throw new IllegalArgumentException(String.format("component visibility boundaries must be between 0 and 1 (inclusive), but were %.3f and %.3f", hiddenOnOrBelow, visibleOnOrAbove));
        }
        if (hiddenOnOrBelow > visibleOnOrAbove) {
            throw new IllegalArgumentException(String.format("visibility boundary for hiding the component (%.3f) must not be greater than the boundary for showing it (%.3f)", hiddenOnOrBelow, visibleOnOrAbove));
        }
        this.shownVisibilityRange = visibleOnOrAbove;
        this.hiddenVisibilityRange = hiddenOnOrBelow;
    }

    public LazyLoad<C> withContentVisibilityRanges(double hiddenOnOrBelow, double visibleOnOrAbove) {
        this.setContentVisibilityRanges(hiddenOnOrBelow, visibleOnOrAbove);
        return this;
    }

    protected void onNowHidden() {
        if (this.lazyLoadedContent != null) {
            ((LazyLoadElement)this.getContent()).removeClassName(LOADED_CLASS_NAME);
            ((LazyLoadElement)this.getContent()).addClassName(EMPTY_CLASS_NAME);
            ((LazyLoadElement)this.getContent()).remove(new Component[]{this.lazyLoadedContent});
            this.lazyLoadedContent = null;
        }
    }

    protected void onNowVisible() {
        if (this.lazyLoadedContent == null) {
            ((LazyLoadElement)this.getContent()).removeClassName(EMPTY_CLASS_NAME);
            ((LazyLoadElement)this.getContent()).addClassName(LOADED_CLASS_NAME);
            this.lazyLoadedContent = (Component)this.componentProvider.get();
            ((LazyLoadElement)this.getContent()).add(new Component[]{this.lazyLoadedContent});
        }
    }

    public boolean isOnlyLoadedOnce() {
        return this.onlyLoadedOnce;
    }

    public Optional<C> getLoadedContent() {
        return Optional.ofNullable(this.lazyLoadedContent);
    }

    public boolean isLoaded() {
        return this.lazyLoadedContent == null;
    }

    @Tag(value="lazy-load")
    public static final class LazyLoadElement
    extends Div {
    }
}

