/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.tabs;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.dom.PropertyChangeEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithItemsMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.tabs.TabContentGenerator;
import org.vaadin.miki.superfields.tabs.TabHandler;
import org.vaadin.miki.superfields.tabs.TabHandlers;
import org.vaadin.miki.superfields.tabs.TabHeaderGenerator;

@Tag(value="super-tabs")
@CssImport(value="./styles/super-tabs-multiline.css", themeFor="vaadin-tabs")
public class SuperTabs<T>
extends CustomField<T>
implements HasStyle,
WithItemsMixin<T, SuperTabs<T>>,
WithIdMixin<SuperTabs<T>>,
WithHelperMixin<SuperTabs<T>>,
WithHelperPositionableMixin<SuperTabs<T>>,
WithLabelMixin<SuperTabs<T>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T, SuperTabs<T>> {
    public static final Supplier<Div> DEFAULT_TAB_CONTENTS_CONTAINER = Div::new;
    public static final String MULTILINE_THEME_NAME = "multi-line-tabs";
    private final Tabs tabs = new Tabs();
    private final HasComponents contents;
    private final Map<Tab, Component> tabsToContents = new HashMap<Tab, Component>();
    private final transient List<Map.Entry<T, Tab>> values = new ArrayList<Map.Entry<T, Tab>>();
    private TabHandler tabHandler;
    private TabHeaderGenerator<T> tabHeaderGenerator;
    private TabContentGenerator<T> tabContentGenerator;
    private boolean customValueAllowed = false;
    private boolean multiline = false;

    public SuperTabs() {
        this(DEFAULT_TAB_CONTENTS_CONTAINER, new Object[0]);
    }

    @SafeVarargs
    public <C extends Component> SuperTabs(Supplier<C> mainContentSupplier, T ... values) {
        this(null, mainContentSupplier, null, null, null, values);
    }

    @SafeVarargs
    public SuperTabs(TabContentGenerator<T> tabContentGenerator, T ... values) {
        this((TabHeaderGenerator<T>)null, tabContentGenerator, values);
    }

    @SafeVarargs
    public SuperTabs(TabHeaderGenerator<T> tabHeaderGenerator, TabContentGenerator<T> tabContentGenerator, T ... values) {
        this(null, (TabHeaderGenerator<Object>)tabHeaderGenerator, (TabContentGenerator<Object>)tabContentGenerator, values);
    }

    @SafeVarargs
    public SuperTabs(T defaultValue, TabHeaderGenerator<T> tabHeaderGenerator, TabContentGenerator<T> tabContentGenerator, T ... values) {
        this(defaultValue, null, tabHeaderGenerator, tabContentGenerator, values);
    }

    @SafeVarargs
    public SuperTabs(T defaultValue, TabHandler tabHandler, TabHeaderGenerator<T> tabHeaderGenerator, TabContentGenerator<T> tabContentGenerator, T ... values) {
        this(defaultValue, DEFAULT_TAB_CONTENTS_CONTAINER, tabHandler, tabHeaderGenerator, tabContentGenerator, values);
    }

    @SafeVarargs
    public <C extends Component> SuperTabs(T defaultValue, Supplier<C> mainContentSupplier, TabHandler tabHandler, TabHeaderGenerator<T> tabHeaderGenerator, TabContentGenerator<T> tabContentGenerator, T ... values) {
        super(defaultValue);
        this.setTabHandler(tabHandler);
        this.setTabHeaderGenerator(tabHeaderGenerator);
        this.setTabContentGenerator(tabContentGenerator);
        this.tabs.setAutoselect(false);
        this.tabs.setWidthFull();
        this.tabs.getElement().getClassList().add((Object)"part-of-supertabs");
        Component mainContents = (Component)mainContentSupplier.get();
        if (mainContents instanceof HasSize) {
            ((HasSize)mainContents).setWidthFull();
        }
        this.add(new Component[]{this.tabs, mainContents});
        this.contents = (HasComponents)mainContents;
        this.tabs.addSelectedChangeListener(this::onTabChanged);
        this.addTab(values);
    }

    private void onTabChanged(Tabs.SelectedChangeEvent event) {
        if (event.getPreviousTab() != null && this.tabsToContents.containsKey(event.getPreviousTab())) {
            this.tabHandler.tabDeselected(event.getPreviousTab(), this.tabsToContents.get(event.getPreviousTab()), this.contents);
        }
        if (event.getSelectedTab() != null && this.tabsToContents.containsKey(event.getSelectedTab())) {
            this.tabHandler.tabSelected(event.getSelectedTab(), this.tabsToContents.get(event.getSelectedTab()), this.contents);
        }
        this.updateValue();
    }

    protected void addNewTab(T value, boolean select) {
        Tab tab = this.getTabHeaderGenerator().generateTab(value);
        Component content = this.getTabContentGenerator().generateComponent(value);
        this.addNewTab(value, tab, content, select);
    }

    protected void addNewTab(T value, Tab tab, Component content, boolean select) {
        this.tabsToContents.put(tab, content);
        this.values.add(new AbstractMap.SimpleImmutableEntry<T, Tab>(value, tab));
        this.tabs.add(new Tab[]{tab});
        this.tabHandler.tabAdded(tab, content, this.contents);
        if (select) {
            if (!Objects.equals(this.tabs.getSelectedTab(), tab)) {
                this.tabs.setSelectedTab(tab);
            } else {
                this.updateValue();
            }
        }
        tab.getElement().addPropertyChangeListener("selected", this::tabSelectedPropertyChanged);
    }

    private void tabSelectedPropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selected") && (propertyChangeEvent.getOldValue() == null || !Boolean.parseBoolean(propertyChangeEvent.getOldValue().toString())) && propertyChangeEvent.getValue() != null && Boolean.parseBoolean(propertyChangeEvent.getValue().toString())) {
            this.tabsToContents.entrySet().stream().filter(entry -> Objects.equals(((Tab)entry.getKey()).getElement(), propertyChangeEvent.getSource())).findFirst().map(Map.Entry::getKey).ifPresent(arg_0 -> ((Tabs)this.tabs).setSelectedTab(arg_0));
        }
    }

    @SafeVarargs
    public final void addTab(T ... values) {
        this.addTabs(Arrays.asList(values));
    }

    public void addTabs(Collection<T> values) {
        values.forEach(value -> {
            Optional<Map.Entry<Object, Tab>> perhapsValueAndTab = this.getValueAndTab(value);
            if (perhapsValueAndTab.isPresent()) {
                this.tabs.setSelectedTab(perhapsValueAndTab.get().getValue());
            } else {
                this.addNewTab(value, this.values.isEmpty());
            }
        });
    }

    public void addTab(T value, Tab tabHeader, Component tabContents) {
        Optional<Map.Entry<T, Tab>> perhapsValueAndTab = this.getValueAndTab(value);
        if (perhapsValueAndTab.isPresent()) {
            this.tabs.setSelectedTab(perhapsValueAndTab.get().getValue());
        } else {
            this.addNewTab(value, tabHeader, tabContents, this.values.isEmpty());
        }
    }

    protected void removeExistingTab(T value, Tab header) {
        if (Objects.equals(header, this.tabs.getSelectedTab())) {
            this.tabs.setSelectedTab(null);
        }
        this.tabs.remove(new Component[]{header});
        Component component = this.tabsToContents.get(header);
        this.tabHandler.tabRemoved(header, component, this.contents);
        this.values.removeIf(e -> Objects.equals(value, e.getKey()));
    }

    public void removeTab(T value) {
        this.getValueAndTab(value).ifPresent(e -> this.removeExistingTab(e.getKey(), (Tab)e.getValue()));
    }

    protected Optional<Map.Entry<T, Tab>> getValueAndTab(T value) {
        return this.values.stream().filter(e -> Objects.equals(value, e.getKey())).findFirst();
    }

    public Optional<Tab> getTabHeader(T value) {
        return this.getValueAndTab(value).map(Map.Entry::getValue);
    }

    public Optional<Component> getTabContents(T value) {
        return this.getValueAndTab(value).map(e -> this.tabsToContents.get(e.getValue()));
    }

    protected T generateModelValue() {
        if (this.tabs.getSelectedIndex() < this.values.size() && this.tabs.getSelectedIndex() >= 0) {
            return this.values.get(this.tabs.getSelectedIndex()).getKey();
        }
        return (T)this.getEmptyValue();
    }

    protected void setPresentationValue(T t) {
        Optional<Map.Entry> perhapsValue = this.values.stream().filter(e -> Objects.equals(t, e.getKey())).findFirst();
        if (perhapsValue.isPresent()) {
            this.tabs.setSelectedTab((Tab)perhapsValue.get().getValue());
        } else if (this.isCustomValueAllowed()) {
            this.addNewTab(t, true);
        } else {
            this.updateValue();
        }
    }

    public List<T> getValues() {
        return this.values.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public int size() {
        return this.values.size();
    }

    public void setTabContentGenerator(TabContentGenerator<T> tabContentGenerator) {
        this.tabContentGenerator = Optional.ofNullable(tabContentGenerator).orElse(t -> new Span(String.valueOf(t)));
    }

    public TabContentGenerator<T> getTabContentGenerator() {
        return this.tabContentGenerator;
    }

    public SuperTabs<T> withTabContentGenerator(TabContentGenerator<T> tabContentGenerator) {
        this.setTabContentGenerator(tabContentGenerator);
        return this;
    }

    public void setTabHeaderGenerator(TabHeaderGenerator<T> tabHeaderGenerator) {
        this.tabHeaderGenerator = Optional.ofNullable(tabHeaderGenerator).orElse(t -> new Tab(String.valueOf(t)));
    }

    public TabHeaderGenerator<T> getTabHeaderGenerator() {
        return this.tabHeaderGenerator;
    }

    public SuperTabs<T> withTabHeaderGenerator(TabHeaderGenerator<T> tabHeaderGenerator) {
        this.setTabHeaderGenerator(tabHeaderGenerator);
        return this;
    }

    public boolean isCustomValueAllowed() {
        return this.customValueAllowed;
    }

    public void setCustomValueAllowed(boolean customValueAllowed) {
        this.customValueAllowed = customValueAllowed;
    }

    public SuperTabs<T> withCustomValueAllowed(boolean customValueAllowed) {
        this.setCustomValueAllowed(customValueAllowed);
        return this;
    }

    public void setTabHandler(TabHandler tabHandler) {
        if (!Objects.equals(this.tabHandler, tabHandler = Optional.ofNullable(tabHandler).orElse(TabHandlers.REMOVING_HANDLER))) {
            this.values.stream().map(Map.Entry::getValue).forEach(tab -> {
                if (tab.isSelected()) {
                    this.tabHandler.tabDeselected((Tab)tab, this.tabsToContents.get(tab), this.contents);
                }
                this.tabHandler.tabRemoved((Tab)tab, this.tabsToContents.get(tab), this.contents);
            });
            this.tabHandler = tabHandler;
            this.values.stream().map(Map.Entry::getValue).forEach(tabHeader -> {
                Component tabContents = this.tabsToContents.get(tabHeader);
                this.tabHandler.tabAdded((Tab)tabHeader, tabContents, this.contents);
                if (tabHeader.isSelected()) {
                    this.tabHandler.tabSelected((Tab)tabHeader, tabContents, this.contents);
                } else {
                    this.tabHandler.tabDeselected((Tab)tabHeader, tabContents, this.contents);
                }
            });
        }
    }

    public TabHandler getTabHandler() {
        return this.tabHandler;
    }

    public SuperTabs<T> withTabHandler(TabHandler tabHandler) {
        this.setTabHandler(tabHandler);
        return this;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
        if (this.multiline) {
            this.tabs.setThemeName(MULTILINE_THEME_NAME);
        } else {
            this.tabs.removeThemeName(MULTILINE_THEME_NAME);
        }
    }

    public SuperTabs<T> withMultiline(boolean multiline) {
        this.setMultiline(multiline);
        return this;
    }

    public void setItems(Collection<T> collection) {
        this.addTabs(collection);
    }

    @Override
    public void setId(String id) {
        this.tabs.setId(id == null ? null : "belongs-to-" + id);
        super.setId(id);
    }
}

