/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.layouts;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.JsModule;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.vaadin.miki.markers.HasIndex;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithIndexMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.layouts.WithFooterComponentsMixin;
import org.vaadin.miki.superfields.layouts.WithHeaderComponentsMixin;

@Tag(value="header-footer-field-wrapper")
@JsModule(value="./header-footer-field-wrapper.js")
public class HeaderFooterFieldWrapper<T, H extends Component, F extends Component>
extends CustomField<T>
implements WithLabelMixin<HeaderFooterFieldWrapper<T, H, F>>,
WithIdMixin<HeaderFooterFieldWrapper<T, H, F>>,
WithHelperMixin<HeaderFooterFieldWrapper<T, H, F>>,
WithHelperPositionableMixin<HeaderFooterFieldWrapper<T, H, F>>,
WithHeaderComponentsMixin<H, HeaderFooterFieldWrapper<T, H, F>>,
WithFooterComponentsMixin<F, HeaderFooterFieldWrapper<T, H, F>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T, HeaderFooterFieldWrapper<T, H, F>>,
WithIndexMixin<HeaderFooterFieldWrapper<T, H, F>> {
    private final HasValue<?, T> field;
    private final H header;
    private final F footer;
    private int index;
    private boolean disablingHeaderOnReadOnly = true;
    private boolean disablingFooterOnReadOnly = true;

    public <R extends Component, V extends Component> HeaderFooterFieldWrapper(Supplier<R> rootSupplier, H header, V field, F footer) {
        super(((HasValue)field).getEmptyValue());
        this.field = (HasValue)field;
        this.header = header;
        this.footer = footer;
        this.field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateValue());
        Component root = (Component)rootSupplier.get();
        if (header != null) {
            ((HasComponents)root).add(new Component[]{header});
        }
        ((HasComponents)root).add(new Component[]{field});
        if (footer != null) {
            ((HasComponents)root).add(new Component[]{footer});
        }
        this.add(new Component[]{root});
    }

    public void setLabel(String label) {
        HasValue<?, T> hasValue = this.field;
        if (hasValue instanceof HasLabel) {
            HasLabel hasLabel = (HasLabel)hasValue;
            hasLabel.setLabel(label);
        } else {
            super.setLabel(label);
        }
    }

    public String getLabel() {
        String string;
        HasValue<?, T> hasValue = this.field;
        if (hasValue instanceof HasLabel) {
            HasLabel hasLabel = (HasLabel)hasValue;
            string = hasLabel.getLabel();
        } else {
            string = super.getLabel();
        }
        return string;
    }

    public void setHelperComponent(Component component) {
        HasValue<?, T> hasValue = this.field;
        if (hasValue instanceof HasHelper) {
            HasHelper hasHelper = (HasHelper)hasValue;
            hasHelper.setHelperComponent(component);
        } else {
            super.setHelperComponent(component);
        }
    }

    public void setHelperText(String helperText) {
        HasValue<?, T> hasValue = this.field;
        if (hasValue instanceof HasHelper) {
            HasHelper hasHelper = (HasHelper)hasValue;
            hasHelper.setHelperText(helperText);
        } else {
            super.setHelperText(helperText);
        }
    }

    protected T generateModelValue() {
        return (T)this.field.getValue();
    }

    protected void setPresentationValue(T t) {
        this.field.setValue(Objects.requireNonNullElse(t, this.field.getEmptyValue()));
    }

    @Override
    public Optional<F> getFooter() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public Optional<H> getHeader() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private void propagateSetIndex(int index, Stream<Component> components) {
        components.filter(HasIndex.class::isInstance).map(HasIndex.class::cast).forEach(c -> c.setIndex(index));
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
        Stream.of(this.getHeader(), this.getFooter()).filter(Optional::isPresent).map(Optional::get).map(rec$ -> ((Component)rec$).getChildren()).forEach(stream -> this.propagateSetIndex(index, (Stream<Component>)stream));
        HasValue<?, T> hasValue = this.field;
        if (hasValue instanceof HasIndex) {
            HasIndex hasIndex = (HasIndex)hasValue;
            hasIndex.setIndex(index);
        }
    }

    public void setDisablingFooterOnReadOnly(boolean disablingFooterOnReadOnly) {
        this.disablingFooterOnReadOnly = disablingFooterOnReadOnly;
    }

    public boolean isDisablingFooterOnReadOnly() {
        return this.disablingFooterOnReadOnly;
    }

    public final HeaderFooterFieldWrapper<T, H, F> withDisablingFooterOnReadOnly(boolean state) {
        this.setDisablingFooterOnReadOnly(state);
        return this;
    }

    public void setDisablingHeaderOnReadOnly(boolean disablingHeaderOnReadOnly) {
        this.disablingHeaderOnReadOnly = disablingHeaderOnReadOnly;
    }

    public boolean isDisablingHeaderOnReadOnly() {
        return this.disablingHeaderOnReadOnly;
    }

    public final HeaderFooterFieldWrapper<T, H, F> withDisablingHeaderOnReadOnly(boolean state) {
        this.setDisablingHeaderOnReadOnly(state);
        return this;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.field.setReadOnly(readOnly);
        if (this.isDisablingFooterOnReadOnly()) {
            this.getFooter().ifPresent(f -> ((HasEnabled)f).setEnabled(!readOnly));
        }
        if (this.isDisablingHeaderOnReadOnly()) {
            this.getHeader().ifPresent(h -> ((HasEnabled)h).setEnabled(!readOnly));
        }
    }
}

