/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.numbers;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.vaadin.miki.superfields.numbers.AbstractSuperNumberField;

@JsModule(value="./super-integer-field.ts")
@Tag(value="super-integer-field")
public class SuperIntegerField
extends AbstractSuperNumberField<Integer, SuperIntegerField> {
    public SuperIntegerField() {
        this("");
    }

    public SuperIntegerField(Locale locale) {
        this("", locale);
    }

    public SuperIntegerField(String label) {
        this(label, Locale.getDefault());
    }

    public SuperIntegerField(String label, Locale locale) {
        this(0, label, locale);
    }

    public SuperIntegerField(Integer defaultValue, String label) {
        this(defaultValue, label, Locale.getDefault());
    }

    public SuperIntegerField(Integer defaultValue, String label, Locale locale) {
        super(defaultValue, (SerializablePredicate & Serializable)d -> d < 0, Math::abs, label, locale, 0);
    }

    @Override
    protected Integer parseRawValue(String rawValue, DecimalFormat format) throws ParseException {
        return format.parse(rawValue).intValue();
    }

    @Override
    public void setDecimalFormat(DecimalFormat format) {
        format.setMaximumFractionDigits(0);
        super.setDecimalFormat(format);
    }
}

