/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.object.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vaadin.miki.superfields.object.Property;
import org.vaadin.miki.superfields.object.PropertyGroupingProvider;
import org.vaadin.miki.superfields.object.PropertyMetadata;

public class MetadataBasedGroupingProvider
implements PropertyGroupingProvider {
    public static final Set<Class<?>> ACCEPTED_SORTING_METADATA_TYPES = Set.of(Integer.class, Integer.TYPE);
    public static final Class<String> ACCEPTED_GROUPING_METADATA_TYPE = String.class;
    private String groupingMetadataName;
    private String sortingMetadataName;

    @Override
    public <T> Map<String, List<Property<T, ?>>> groupDefinitions(List<Property<T, ?>> definitions) {
        if (this.getSortingMetadataName() != null) {
            definitions.sort(Comparator.comparingInt(def -> {
                PropertyMetadata metadata = def.getMetadata().get(this.getSortingMetadataName());
                if (metadata != null && ACCEPTED_SORTING_METADATA_TYPES.contains(metadata.getValueType())) {
                    return (Integer)metadata.getValue();
                }
                return Integer.MAX_VALUE;
            }).thenComparing(Property::getName));
        }
        LinkedHashMap result = new LinkedHashMap();
        if (this.getGroupingMetadataName() != null) {
            definitions.forEach(def -> {
                PropertyMetadata metadata = def.getMetadata().get(this.getGroupingMetadataName());
                String groupName = metadata != null && ACCEPTED_GROUPING_METADATA_TYPE.isInstance(metadata.getValue()) ? ACCEPTED_GROUPING_METADATA_TYPE.cast(metadata.getValue()) : def.getName();
                result.computeIfAbsent(groupName, g -> new ArrayList()).add(def);
            });
        } else {
            definitions.forEach(def -> result.put(def.getName(), Collections.singletonList(def)));
        }
        return result;
    }

    public String getGroupingMetadataName() {
        return this.groupingMetadataName;
    }

    public void setGroupingMetadataName(String groupingMetadataName) {
        this.groupingMetadataName = groupingMetadataName;
    }

    public final MetadataBasedGroupingProvider withGroupingMetadataName(String metadataName) {
        this.setGroupingMetadataName(metadataName);
        return this;
    }

    public String getSortingMetadataName() {
        return this.sortingMetadataName;
    }

    public void setSortingMetadataName(String sortingMetadataName) {
        this.sortingMetadataName = sortingMetadataName;
    }

    public final MetadataBasedGroupingProvider withSortingMetadataName(String metadataName) {
        this.setSortingMetadataName(metadataName);
        return this;
    }
}

