/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.collections;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.vaadin.miki.markers.HasIndex;
import org.vaadin.miki.markers.HasReadOnly;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.collections.CollectionController;
import org.vaadin.miki.superfields.collections.CollectionLayoutProvider;
import org.vaadin.miki.superfields.collections.CollectionValueComponentProvider;
import org.vaadin.miki.superfields.collections.WithCollectionElementFilterMixin;
import org.vaadin.miki.superfields.collections.WithCollectionValueComponentProviderMixin;

@Tag(value="collection-field")
@CssImport(value="./styles/label-positions.css", themeFor="collection-field")
@JsModule(value="./collection-field.js")
public class CollectionField<T, C extends Collection<T>>
extends CustomField<C>
implements CollectionController,
WithIdMixin<CollectionField<T, C>>,
HasStyle,
WithCollectionValueComponentProviderMixin<T, CollectionField<T, C>>,
WithHelperMixin<CollectionField<T, C>>,
WithHelperPositionableMixin<CollectionField<T, C>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<C>, C>, C, CollectionField<T, C>>,
WithCollectionElementFilterMixin<T, CollectionField<T, C>>,
WithLabelPositionableMixin<CollectionField<T, C>>,
WithLabelMixin<CollectionField<T, C>> {
    public static final String LAYOUT_STYLE_NAME = "collection-field-main-layout";
    public static final int NO_ITEM_INDEX = -1;
    public static final CollectionLayoutProvider<FlexLayout> DEFAULT_LAYOUT_PROVIDER = (index, controller) -> {
        FlexLayout result = new FlexLayout();
        result.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
        return result;
    };
    private final List<HasValue<?, T>> fields = new ArrayList();
    private final SerializableSupplier<C> emptyCollectionSupplier;
    private final Map<Component, Registration> eventRegistrations = new HashMap<Component, Registration>();
    private HasComponents layout;
    private CollectionValueComponentProvider<T, ?> collectionValueComponentProvider;
    private boolean valueUpdateInProgress = false;
    private SerializablePredicate<T> collectionElementFilter = Objects::nonNull;

    public <F extends Component> CollectionField(SerializableSupplier<C> emptyCollectionSupplier, SerializableSupplier<F> fieldSupplier) {
        this(emptyCollectionSupplier, DEFAULT_LAYOUT_PROVIDER, (index, controller) -> (Component)fieldSupplier.get());
    }

    public CollectionField(SerializableSupplier<C> emptyCollectionSupplier, CollectionValueComponentProvider<T, ?> collectionValueComponentProvider) {
        this(emptyCollectionSupplier, DEFAULT_LAYOUT_PROVIDER, collectionValueComponentProvider);
    }

    public <F extends Component> CollectionField(SerializableSupplier<C> emptyCollectionSupplier, CollectionLayoutProvider<?> collectionLayoutProvider, SerializableSupplier<F> fieldSupplier) {
        this(emptyCollectionSupplier, collectionLayoutProvider, (index, controller) -> (Component)fieldSupplier.get());
    }

    public CollectionField(SerializableSupplier<C> emptyCollectionSupplier, CollectionLayoutProvider<?> collectionLayoutProvider, CollectionValueComponentProvider<T, ?> collectionValueComponentProvider) {
        super((Object)((Collection)emptyCollectionSupplier.get()));
        this.emptyCollectionSupplier = emptyCollectionSupplier;
        this.updateLayout((Component)collectionLayoutProvider.provideComponent(-1, this));
        this.setCollectionValueComponentProvider(collectionValueComponentProvider);
    }

    private <L extends Component> void updateLayout(L newLayout) {
        if (this.layout != null) {
            this.remove(new Component[]{(Component)this.layout});
        }
        this.layout = (HasComponents)newLayout;
        this.add(new Component[]{newLayout});
        HasComponents hasComponents = this.layout;
        if (hasComponents instanceof HasStyle) {
            HasStyle hasStyle = (HasStyle)hasComponents;
            hasStyle.addClassName(LAYOUT_STYLE_NAME);
        }
    }

    public final void setCollectionLayoutProvider(CollectionLayoutProvider<?> collectionLayoutProvider) {
        this.updateLayout((Component)Objects.requireNonNullElse(collectionLayoutProvider, DEFAULT_LAYOUT_PROVIDER).provideComponent(-1, this));
        this.repaintFields((Collection)this.getValue());
    }

    public final CollectionField<T, C> withCollectionLayoutProvider(CollectionLayoutProvider<?> collectionLayoutProvider) {
        this.setCollectionLayoutProvider(collectionLayoutProvider);
        return this;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        HasReadOnly.setReadOnly(readOnly, (Component)this.layout);
    }

    protected C generateModelValue() {
        return (C)((Collection)this.fields.stream().map(HasValue::getValue).filter((Predicate<Object>)this.getCollectionElementFilter()).collect(Collectors.toCollection(this.emptyCollectionSupplier)));
    }

    protected void updateValue() {
        if (!this.valueUpdateInProgress) {
            super.updateValue();
            if (super.getValue() != null && this.fields.size() != ((Collection)super.getValue()).size() || super.getValue() == null && !this.fields.isEmpty()) {
                this.repaintFields((Collection)super.getValue());
            }
        }
    }

    protected void setPresentationValue(C ts) {
        if (ts == null) {
            ts = (Collection)this.emptyCollectionSupplier.get();
        }
        this.repaintFields(ts);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    protected void updateIndices(int fromIndex) {
        for (int zmp1 = fromIndex; zmp1 < this.fields.size(); ++zmp1) {
            HasValue<?, T> hasValue = this.fields.get(zmp1);
            if (!(hasValue instanceof HasIndex)) continue;
            HasIndex hasIndex = (HasIndex)hasValue;
            hasIndex.setIndex(zmp1);
        }
    }

    @Override
    public void add(int atIndex) {
        HasValue hasValue = (HasValue)this.getCollectionValueComponentProvider().provideComponent(atIndex, this);
        this.eventRegistrations.put((Component)hasValue, hasValue.addValueChangeListener(this::valueChangedInSubComponent));
        this.fields.add(atIndex, hasValue);
        this.layout.addComponentAtIndex(atIndex, (Component)hasValue);
        this.updateIndices(atIndex);
        this.updateValue();
    }

    @Override
    public void remove(int atIndex) {
        Component removed = (Component)this.fields.remove(atIndex);
        this.layout.remove(new Component[]{removed});
        this.eventRegistrations.remove(removed).remove();
        this.updateIndices(atIndex);
        this.updateValue();
    }

    @Override
    public void removeAll() {
        this.clear();
    }

    protected void repaintFields(C ts) {
        this.valueUpdateInProgress = true;
        while (this.fields.size() > ts.size()) {
            this.remove();
        }
        while (this.fields.size() < ts.size()) {
            this.add();
        }
        int zmp1 = 0;
        for (Object t : ts) {
            this.fields.get(zmp1++).setValue(t);
        }
        this.valueUpdateInProgress = false;
        this.updateValue();
    }

    private void valueChangedInSubComponent(HasValue.ValueChangeEvent<T> o) {
        if (!this.valueUpdateInProgress) {
            this.updateValue();
        }
    }

    @Override
    public final void setCollectionValueComponentProvider(CollectionValueComponentProvider<T, ?> collectionValueComponentProvider) {
        this.collectionValueComponentProvider = collectionValueComponentProvider;
        this.valueUpdateInProgress = true;
        this.layout.remove((Component[])this.fields.stream().map(Component.class::cast).toArray(Component[]::new));
        this.fields.clear();
        this.repaintFields((Collection)this.getValue());
    }

    @Override
    public <W extends Component> CollectionValueComponentProvider<T, W> getCollectionValueComponentProvider() {
        return this.collectionValueComponentProvider;
    }

    @Override
    public void setCollectionElementFilter(SerializablePredicate<T> collectionElementFilter) {
        this.collectionElementFilter = collectionElementFilter == null ? t -> true : collectionElementFilter;
    }

    @Override
    public SerializablePredicate<T> getCollectionElementFilter() {
        return this.collectionElementFilter;
    }

    public void focus() {
        if (!this.fields.isEmpty() && this.fields.get(0) instanceof Focusable) {
            ((Focusable)this.fields.get(0)).focus();
        }
        super.focus();
    }

    final HasValue<?, T> getField(int index) {
        return this.fields.get(index);
    }
}

