/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.dates;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.timepicker.TimePicker;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Optional;
import org.vaadin.miki.markers.WithDatePatternMixin;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithLocaleMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.shared.dates.DatePattern;
import org.vaadin.miki.superfields.dates.DatePatternDelegate;
import org.vaadin.miki.superfields.dates.HasSuperDatePickerI18N;
import org.vaadin.miki.superfields.dates.SuperDatePickerI18n;
import org.vaadin.miki.superfields.dates.SuperDatePickerI18nHelper;
import org.vaadin.miki.util.ReflectTools;

@JsModule(value="./super-date-time-picker.js")
@Tag(value="super-date-time-picker")
@CssImport(value="./styles/label-positions.css", themeFor="super-date-time-picker")
public class SuperDateTimePicker
extends DateTimePicker
implements HasSuperDatePickerI18N,
WithLabelPositionableMixin<SuperDateTimePicker>,
WithLocaleMixin<SuperDateTimePicker>,
WithLabelMixin<SuperDateTimePicker>,
WithDatePatternMixin<SuperDateTimePicker>,
WithIdMixin<SuperDateTimePicker>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>, LocalDateTime, SuperDateTimePicker>,
WithHelperMixin<SuperDateTimePicker>,
WithHelperPositionableMixin<SuperDateTimePicker> {
    private static final String INTERNAL_DATE_PICKER_FIELD_NAME = "datePicker";
    private static final String INTERNAL_TIME_PICKER_FIELD_NAME = "timePicker";
    private final DatePatternDelegate<SuperDateTimePicker> delegate = new DatePatternDelegate<SuperDateTimePicker>(this);
    private DatePattern datePattern;

    public SuperDateTimePicker() {
        this(Locale.getDefault());
    }

    public SuperDateTimePicker(Locale locale) {
        this.setLocale(locale);
    }

    public SuperDateTimePicker(String label) {
        super(label);
        this.setLocale(Locale.getDefault());
    }

    public SuperDateTimePicker(String label, LocalDateTime initialDateTime) {
        super(label, initialDateTime);
        this.setLocale(Locale.getDefault());
    }

    public SuperDateTimePicker(LocalDateTime initialDateTime) {
        super(initialDateTime);
        this.setLocale(Locale.getDefault());
    }

    public SuperDateTimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(listener);
        this.setLocale(Locale.getDefault());
    }

    public SuperDateTimePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(label, listener);
        this.setLocale(Locale.getDefault());
    }

    public SuperDateTimePicker(LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(initialDateTime, listener);
        this.setLocale(Locale.getDefault());
    }

    public SuperDateTimePicker(String label, LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        super(label, initialDateTime, listener);
        this.setLocale(Locale.getDefault());
    }

    public SuperDateTimePicker(LocalDateTime initialDateTime, Locale locale) {
        super(initialDateTime);
        this.setLocale(locale);
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.delegate != null) {
            this.delegate.initPatternSetting();
            SuperDatePickerI18nHelper.updateI18N(locale, () -> ((SuperDateTimePicker)this).getDatePickerI18n(), this::setDatePickerI18n);
        }
        super.setLocale(locale);
    }

    public Optional<DatePicker> getInternalDatePicker() {
        return ReflectTools.getValueOfField(this, DatePicker.class, INTERNAL_DATE_PICKER_FIELD_NAME);
    }

    public Optional<TimePicker> getInternalTimePicker() {
        return ReflectTools.getValueOfField(this, TimePicker.class, INTERNAL_TIME_PICKER_FIELD_NAME);
    }

    @Override
    public void setDatePattern(DatePattern pattern) {
        this.datePattern = pattern;
        this.delegate.updateClientSidePattern();
    }

    @Override
    public DatePattern getDatePattern() {
        return this.datePattern;
    }

    @Override
    public SuperDatePickerI18n getSuperDatePickerI18n() {
        return (SuperDatePickerI18n)this.getDatePickerI18n();
    }

    public void setDatePickerI18n(DatePicker.DatePickerI18n i18n) {
        if (!(i18n instanceof SuperDatePickerI18n)) {
            i18n = SuperDatePickerI18nHelper.from(i18n, this.getLocale());
        }
        super.setDatePickerI18n(i18n);
    }
}

