/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.gridselect;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import java.util.Collection;
import java.util.Set;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithItemsMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.gridselect.AbstractGridSelect;
import org.vaadin.miki.superfields.gridselect.RestrictedModeGrid;

@Tag(value="grid-select")
@CssImport.Container(value={@CssImport(value="./styles/label-positions.css", themeFor="grid-select"), @CssImport(value="./styles/label-positions-grids.css", themeFor="grid-select")})
@JsModule(value="./grid-select.js")
public class GridSelect<V>
extends AbstractGridSelect<V, V>
implements WithIdMixin<GridSelect<V>>,
WithItemsMixin<V, GridSelect<V>>,
WithHelperMixin<GridSelect<V>>,
WithHelperPositionableMixin<GridSelect<V>>,
WithLabelMixin<GridSelect<V>>,
WithLabelPositionableMixin<GridSelect<V>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<V>, V>, V, GridSelect<V>> {
    @SafeVarargs
    public GridSelect(V ... items) {
        super(new RestrictedModeGrid());
        this.setItems(items);
    }

    @SafeVarargs
    public GridSelect(Class<V> type, boolean createColumns, V ... items) {
        super(new RestrictedModeGrid<V>(type, createColumns));
        this.setItems(items);
    }

    protected GridSelect(Grid<V> underlyingGrid) {
        super(underlyingGrid);
    }

    protected V generateModelValue() {
        Set items = this.getGrid().getSelectedItems();
        return items.isEmpty() ? null : (V)items.iterator().next();
    }

    protected void setPresentationValue(V v) {
        this.getGrid().select(v);
    }

    public void setItems(Collection<V> collection) {
        this.getGrid().setItems(collection);
        this.getGrid().recalculateColumnWidths();
    }
}

