/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.object;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.function.SerializableSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.markers.HasReadOnly;
import org.vaadin.miki.markers.WithHelperMixin;
import org.vaadin.miki.markers.WithHelperPositionableMixin;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithLabelMixin;
import org.vaadin.miki.markers.WithLabelPositionableMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.layouts.FlexLayoutHelpers;
import org.vaadin.miki.superfields.object.ComponentConfigurator;
import org.vaadin.miki.superfields.object.ComponentGroupConfigurator;
import org.vaadin.miki.superfields.object.DefaultPropertyGroupLayoutProvider;
import org.vaadin.miki.superfields.object.DefaultPropertyGroupingProvider;
import org.vaadin.miki.superfields.object.Property;
import org.vaadin.miki.superfields.object.PropertyComponentBuilder;
import org.vaadin.miki.superfields.object.PropertyGroupLayoutProvider;
import org.vaadin.miki.superfields.object.PropertyGroupingProvider;
import org.vaadin.miki.superfields.object.PropertyProvider;
import org.vaadin.miki.superfields.object.builder.SimplePropertyComponentBuilder;
import org.vaadin.miki.superfields.object.reflect.ReflectivePropertyProvider;

@CssImport(value="./styles/label-positions.css", themeFor="object-field")
@Tag(value="object-field")
@JsModule(value="./object-field.js")
public class ObjectField<T>
extends CustomField<T>
implements HasStyle,
WithHelperMixin<ObjectField<T>>,
WithHelperPositionableMixin<ObjectField<T>>,
WithIdMixin<ObjectField<T>>,
WithLabelMixin<ObjectField<T>>,
WithLabelPositionableMixin<ObjectField<T>>,
WithValueMixin<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T, ObjectField<T>> {
    public static final SerializableSupplier<FlexLayout> DEFAULT_LAYOUT_PROVIDER = FlexLayoutHelpers::column;
    public static final SerializableSupplier<PropertyProvider> DEFAULT_PROPERTY_PROVIDER = ReflectivePropertyProvider::new;
    public static final SerializableSupplier<PropertyComponentBuilder> DEFAULT_COMPONENT_BUILDER = SimplePropertyComponentBuilder::new;
    public static final SerializableSupplier<PropertyGroupingProvider> DEFAULT_GROUPING_PROVIDER = DefaultPropertyGroupingProvider::new;
    public static final SerializableSupplier<PropertyGroupLayoutProvider> DEFAULT_GROUP_LAYOUT_PROVIDER = DefaultPropertyGroupLayoutProvider::new;
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectField.class);
    private final SerializableSupplier<T> emptyObjectSupplier;
    private final Map<Property<T, ?>, HasValue<?, ?>> properties = new LinkedHashMap();
    private final Map<String, Component> groupLayouts = new LinkedHashMap<String, Component>();
    private final Set<Component> componentsNotInGroups = new LinkedHashSet<Component>();
    private final List<Property<T, ?>> definitions = new ArrayList();
    private final List<ComponentConfigurator<T>> configurators = new ArrayList<ComponentConfigurator<T>>();
    private final List<ComponentGroupConfigurator> groupConfigurators = new ArrayList<ComponentGroupConfigurator>();
    private final Class<T> dataType;
    private final HasComponents layout;
    private boolean reloadNeeded = true;
    private PropertyProvider definitionProvider = (PropertyProvider)DEFAULT_PROPERTY_PROVIDER.get();
    private PropertyComponentBuilder componentBuilder = (PropertyComponentBuilder)DEFAULT_COMPONENT_BUILDER.get();
    private PropertyGroupingProvider propertyGroupingProvider = (PropertyGroupingProvider)DEFAULT_GROUPING_PROVIDER.get();
    private PropertyGroupLayoutProvider groupLayoutProvider = (PropertyGroupLayoutProvider)DEFAULT_GROUP_LAYOUT_PROVIDER.get();
    private boolean valueChangeInProgress = false;

    public ObjectField(Class<T> dataType, SerializableSupplier<T> emptyObjectSupplier) {
        this(dataType, emptyObjectSupplier, DEFAULT_LAYOUT_PROVIDER);
    }

    public <L extends Component> ObjectField(Class<T> dataType, SerializableSupplier<T> emptyObjectSupplier, SerializableSupplier<L> layoutSupplier) {
        super(emptyObjectSupplier.get());
        this.emptyObjectSupplier = emptyObjectSupplier;
        this.dataType = dataType;
        Component mainLayout = (Component)layoutSupplier.get();
        this.layout = (HasComponents)mainLayout;
        this.add(new Component[]{mainLayout});
    }

    private <P> void setPropertyOfObject(T object, Property<T, P> definition, HasValue<?, ?> component) {
        if (object != null) {
            definition.getSetter().ifPresent(s -> s.accept(object, component.getValue()));
        }
    }

    private <P> void showPropertyOfObject(T object, Property<T, P> definition, HasValue<?, ?> component) {
        if (object != null) {
            definition.getGetter().ifPresent(getter -> component.setValue(getter.apply(object)));
        }
    }

    protected T generateModelValue() {
        Object result = this.emptyObjectSupplier.get();
        this.properties.forEach((def, field) -> this.setPropertyOfObject((T)result, (Property)def, (HasValue<?, ?>)field));
        LOGGER.debug("ObjectField<{}> - generated model value: {}", (Object)this.getDataType().getSimpleName(), result);
        return (T)result;
    }

    private void prepareComponents(T t) {
        List<Property<T, ?>> newDefinitions = this.getPropertyProvider().getObjectPropertyDefinitions(this.dataType, t);
        LOGGER.debug("> obtained {} definitions for {}", (Object)newDefinitions.size(), this.dataType);
        if (!this.definitions.equals(newDefinitions)) {
            LOGGER.debug("refreshing properties to {}", newDefinitions);
            this.groupLayouts.values().forEach(xva$0 -> this.layout.remove(new Component[]{xva$0}));
            this.componentsNotInGroups.forEach(xva$0 -> this.layout.remove(new Component[]{xva$0}));
            this.properties.clear();
            this.groupLayouts.clear();
            this.componentsNotInGroups.clear();
            this.definitions.clear();
            this.definitions.addAll(newDefinitions);
            Map<String, List<Property<T, ?>>> groupDefinitions = this.getPropertyGroupingProvider().groupDefinitions(this.definitions);
            groupDefinitions.forEach((groupName, groupContents) -> this.getGroupLayoutProvider().buildGroupLayout((String)groupName, groupContents).ifPresentOrElse(groupLayout -> {
                this.groupLayouts.put((String)groupName, (Component)groupLayout);
                List<Component> groupComponents = groupContents.stream().map(definition -> {
                    Object component = this.buildAndConfigureComponentForDefinition(t, (Property)definition);
                    ((HasComponents)groupLayout).add(new Component[]{component});
                    this.properties.put((Property<T, ?>)definition, (HasValue<?, ?>)((HasValue)component));
                    LOGGER.debug("field {} belongs to group {}, added to group layout", (Object)definition.getName(), groupName);
                    return component;
                }).toList();
                this.groupConfigurators.forEach(configurator -> configurator.configureComponentGroup(t, (String)groupName, groupContents, (List<? extends HasValue<?, ?>>)groupComponents));
                this.layout.add(new Component[]{groupLayout});
            }, () -> groupContents.forEach(definition -> {
                Object component = this.buildAndConfigureComponentForDefinition(t, (Property)definition);
                this.layout.add(new Component[]{component});
                this.properties.put((Property<T, ?>)definition, (HasValue<?, ?>)((HasValue)component));
                this.componentsNotInGroups.add((Component)component);
                LOGGER.debug("field {} belongs to main layout", (Object)definition.getName());
            })));
            if (!this.groupConfigurators.isEmpty()) {
                List<HasValue> allComponents = this.definitions.stream().map(this.properties::get).toList();
                this.groupConfigurators.forEach(configurator -> configurator.configureComponentGroup(t, null, this.definitions, allComponents));
            }
        }
    }

    private <P, C extends Component> C buildAndConfigureComponentForDefinition(T t, Property<T, P> definition) {
        Component result = (Component)this.getPropertyComponentBuilder().buildPropertyField(definition).orElseThrow(() -> new IllegalArgumentException(String.format("could not construct a component for property %s (of object %s) using %s", definition.getName(), t, this.getPropertyComponentBuilder().getClass().getSimpleName())));
        ((HasValue)result).addValueChangeListener(this::valueChangedInSubComponent);
        LOGGER.debug("> running component {} ({}) through {} configurator(s)", new Object[]{definition.getName(), result.getClass().getSimpleName(), this.configurators.size()});
        this.configurators.forEach(configurator -> configurator.configureComponent(t, definition, (HasValue)result));
        return (C)result;
    }

    private void valueChangedInSubComponent(HasValue.ValueChangeEvent<?> event) {
        if (!this.valueChangeInProgress) {
            this.updateValue();
            LOGGER.debug("ObjectField<{}> - current value after update: {}", (Object)this.getDataType().getSimpleName(), this.getValue());
        }
    }

    private void reload() {
        this.reloadNeeded = false;
        this.definitions.clear();
    }

    public void repaint() {
        if (this.isReloadNeeded()) {
            this.reload();
        }
        this.prepareComponents(this.getValue());
    }

    protected void setPresentationValue(T t) {
        this.valueChangeInProgress = true;
        if (this.isReloadNeeded()) {
            this.reload();
        }
        this.prepareComponents(t);
        this.properties.forEach((def, field) -> this.showPropertyOfObject(t, (Property)def, (HasValue<?, ?>)field));
        this.valueChangeInProgress = false;
    }

    public Class<T> getDataType() {
        return this.dataType;
    }

    protected void markReloadNeeded() {
        this.reloadNeeded = true;
    }

    protected boolean isReloadNeeded() {
        return this.reloadNeeded;
    }

    public PropertyProvider getPropertyProvider() {
        return this.definitionProvider;
    }

    public void setPropertyProvider(PropertyProvider propertyProvider) {
        this.definitionProvider = Objects.requireNonNullElseGet(propertyProvider, DEFAULT_PROPERTY_PROVIDER);
        this.markReloadNeeded();
    }

    public final ObjectField<T> withPropertyProvider(PropertyProvider provider) {
        this.setPropertyProvider(provider);
        return this;
    }

    public void setPropertyComponentBuilder(PropertyComponentBuilder builder) {
        this.componentBuilder = Objects.requireNonNullElseGet(builder, DEFAULT_COMPONENT_BUILDER);
        this.markReloadNeeded();
    }

    public PropertyComponentBuilder getPropertyComponentBuilder() {
        return this.componentBuilder;
    }

    public final ObjectField<T> withPropertyComponentBuilder(PropertyComponentBuilder builder) {
        this.setPropertyComponentBuilder(builder);
        return this;
    }

    public void setPropertyGroupingProvider(PropertyGroupingProvider propertyGroupingProvider) {
        this.propertyGroupingProvider = Objects.requireNonNullElseGet(propertyGroupingProvider, DEFAULT_GROUPING_PROVIDER);
        this.markReloadNeeded();
    }

    public PropertyGroupingProvider getPropertyGroupingProvider() {
        return this.propertyGroupingProvider;
    }

    public final ObjectField<T> withPropertyGroupingProvider(PropertyGroupingProvider provider) {
        this.setPropertyGroupingProvider(provider);
        return this;
    }

    public PropertyGroupLayoutProvider getGroupLayoutProvider() {
        return this.groupLayoutProvider;
    }

    public void setGroupLayoutProvider(PropertyGroupLayoutProvider groupLayoutProvider) {
        this.groupLayoutProvider = Objects.requireNonNullElseGet(groupLayoutProvider, DEFAULT_GROUP_LAYOUT_PROVIDER);
        this.markReloadNeeded();
    }

    public final ObjectField<T> withGroupLayoutProvider(PropertyGroupLayoutProvider provider) {
        this.setGroupLayoutProvider(provider);
        return this;
    }

    @SafeVarargs
    public final void addComponentConfigurators(ComponentConfigurator<T> ... configurators) {
        this.addComponentConfigurators(Arrays.asList(configurators));
    }

    public void addComponentConfigurators(Collection<ComponentConfigurator<T>> configurators) {
        this.configurators.addAll(configurators);
        this.markReloadNeeded();
    }

    public void removeComponentConfigurator(ComponentConfigurator<T> configurator) {
        this.configurators.remove(configurator);
        this.markReloadNeeded();
    }

    @SafeVarargs
    public final ObjectField<T> withComponentConfigurators(ComponentConfigurator<T> ... configurators) {
        this.addComponentConfigurators(configurators);
        return this;
    }

    public final ObjectField<T> withComponentConfigurators(Collection<ComponentConfigurator<T>> configurators) {
        this.addComponentConfigurators(configurators);
        return this;
    }

    public void clearComponentConfigurators() {
        this.configurators.clear();
        this.markReloadNeeded();
    }

    public void addComponentGroupConfigurators(ComponentGroupConfigurator ... configurators) {
        this.addComponentGroupConfigurators(Arrays.asList(configurators));
    }

    public void addComponentGroupConfigurators(Collection<ComponentGroupConfigurator> configurators) {
        this.groupConfigurators.addAll(configurators);
        this.markReloadNeeded();
    }

    public void removeComponentGroupConfigurator(ComponentGroupConfigurator configurator) {
        this.groupConfigurators.remove(configurator);
        this.markReloadNeeded();
    }

    public final ObjectField<T> withComponentGroupConfigurators(ComponentGroupConfigurator ... configurators) {
        this.addComponentGroupConfigurators(configurators);
        return this;
    }

    public final ObjectField<T> withComponentGroupConfigurators(Collection<ComponentGroupConfigurator> configurators) {
        this.addComponentGroupConfigurators(configurators);
        return this;
    }

    public void clearComponentGroupConfigurators() {
        this.groupConfigurators.clear();
        this.markReloadNeeded();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        HasReadOnly.setReadOnly(readOnly, (Component)this.layout);
    }

    public void focus() {
        if (!this.getPropertiesAndComponents().isEmpty()) {
            this.getPropertiesAndComponents().values().stream().filter(Focusable.class::isInstance).findFirst().map(Focusable.class::cast).ifPresent(Focusable::focus);
        }
        super.focus();
    }

    Map<Property<T, ?>, HasValue<?, ?>> getPropertiesAndComponents() {
        return this.properties;
    }

    Map<String, Component> getGroupLayouts() {
        return this.groupLayouts;
    }

    Set<Component> getComponentsNotInGroups() {
        return this.componentsNotInGroups;
    }
}

