/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.object.reflect;

import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.superfields.object.Property;
import org.vaadin.miki.superfields.object.PropertyProvider;
import org.vaadin.miki.superfields.object.reflect.DoNotScanSuperclasses;
import org.vaadin.miki.superfields.object.reflect.Ignore;
import org.vaadin.miki.superfields.object.reflect.MetadataProvider;
import org.vaadin.miki.superfields.object.reflect.UseActualType;
import org.vaadin.miki.util.ReflectTools;

public class ReflectivePropertyProvider
implements PropertyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectivePropertyProvider.class);
    private final Map<Class<?>, List<Property<?, ?>>> cache = new HashMap();
    private final Set<Class<?>> notCachedTypes = new HashSet();
    private final List<MetadataProvider> metadataProviders = new ArrayList<MetadataProvider>();
    private boolean usingFakeSettersWhenNotPresent = false;
    private boolean usingFakeGettersWhenNotPresent = false;

    @Override
    public <T> List<Property<T, ?>> getObjectPropertyDefinitions(Class<T> type, T instance) {
        if (instance != null) {
            type = instance.getClass();
        }
        if (this.notCachedTypes.contains(type)) {
            return this.buildProperties(type, instance);
        }
        return this.cache.computeIfAbsent(type, t -> this.buildProperties((Class)t, instance));
    }

    private <T> List<Property<T, ?>> buildProperties(Class<T> type, Object instance) {
        return ReflectTools.extractFieldsWithMethods(type, type.isAnnotationPresent(DoNotScanSuperclasses.class)).entrySet().stream().filter(fieldEntry -> !((Field)fieldEntry.getKey()).isAnnotationPresent(Ignore.class)).map(fieldEntry -> {
            Object fieldValue = null;
            if (((Field)fieldEntry.getKey()).isAnnotationPresent(UseActualType.class)) {
                try {
                    this.notCachedTypes.add(type);
                    fieldValue = instance == null || ((Method[])fieldEntry.getValue())[0] == null ? null : ((Method[])fieldEntry.getValue())[0].invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.warn("could not determine the actual type for field {}.{}; using declared type {} instead", new Object[]{type, ((Field)fieldEntry.getKey()).getName(), ((Field)fieldEntry.getKey()).getType().getSimpleName(), e});
                }
            }
            return this.buildDefinition(type, (Field)fieldEntry.getKey(), fieldValue == null ? ((Field)fieldEntry.getKey()).getType() : fieldValue.getClass(), ((Method[])fieldEntry.getValue())[0], ((Method[])fieldEntry.getValue())[1]);
        }).collect(Collectors.toList());
    }

    private <T, P> SerializableBiConsumer<T, P> getSetterFromMethod(Method method) {
        if (method != null) {
            return (SerializableBiConsumer & Serializable)(t, o) -> {
                try {
                    method.invoke(t, o);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("cannot access method " + method.getName(), e);
                }
            };
        }
        if (this.isUsingFakeSettersWhenNotPresent()) {
            return (SerializableBiConsumer & Serializable)(t, p) -> {};
        }
        return null;
    }

    private <T, P> SerializableFunction<T, P> getGetterFromMethod(Method method) {
        if (method != null) {
            return (SerializableFunction & Serializable)t -> {
                try {
                    return method.invoke(t, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            };
        }
        if (this.isUsingFakeGettersWhenNotPresent()) {
            return (SerializableFunction & Serializable)t -> null;
        }
        return null;
    }

    private <T, P> Property<T, P> buildDefinition(Class<T> type, Field field, Class<?> fieldType, Method getter, Method setter) {
        return new Property(type, field.getName(), fieldType, this.getSetterFromMethod(setter), this.getGetterFromMethod(getter), this.metadataProviders.stream().flatMap(provider -> provider.getMetadata(field.getName(), field, setter, getter).stream()).toList());
    }

    public final void addMetadataProvider(MetadataProvider ... providers) {
        this.metadataProviders.addAll(Arrays.stream(providers).filter(Objects::nonNull).toList());
    }

    public final ReflectivePropertyProvider withMetadataProvider(MetadataProvider ... providers) {
        this.addMetadataProvider(providers);
        return this;
    }

    public boolean isUsingFakeSettersWhenNotPresent() {
        return this.usingFakeSettersWhenNotPresent;
    }

    public void setUsingFakeSettersWhenNotPresent(boolean usingFakeSettersWhenNotPresent) {
        this.usingFakeSettersWhenNotPresent = usingFakeSettersWhenNotPresent;
    }

    public final ReflectivePropertyProvider withUsingFakeSettersWhenNotPresent(boolean setting) {
        this.setUsingFakeSettersWhenNotPresent(setting);
        return this;
    }

    public boolean isUsingFakeGettersWhenNotPresent() {
        return this.usingFakeGettersWhenNotPresent;
    }

    public void setUsingFakeGettersWhenNotPresent(boolean usingFakeGettersWhenNotPresent) {
        this.usingFakeGettersWhenNotPresent = usingFakeGettersWhenNotPresent;
    }

    public final ReflectivePropertyProvider withUsingFakeGettersWhenNotPresent(boolean setting) {
        this.setUsingFakeGettersWhenNotPresent(setting);
        return this;
    }
}

