/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.contentaware;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.superfields.contentaware.ContentChangeEvent;
import org.vaadin.miki.superfields.contentaware.ContentChangeListener;
import org.vaadin.miki.superfields.contentaware.ContentChangeNotifier;

@Tag(value="content-aware")
public class ContentAware
extends Div
implements ContentChangeNotifier,
WithIdMixin<ContentAware> {
    private boolean active = false;

    @ClientCallable
    private void mutationObserved(int addedNodeCount, int removedNodeCount) {
        LoggerFactory.getLogger(this.getClass()).info("mutation observed; added {}, removed {} nodes", (Object)addedNodeCount, (Object)removedNodeCount);
        this.fireEvent(new ContentChangeEvent(this, true, addedNodeCount, removedNodeCount));
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            this.getElement().executeJs("console.log('CA: setting up content-aware'); if($0.observer === undefined) {$0.observer = new MutationObserver((list, obs) => {list.forEach( (mutation) => {$0.$server.mutationObserved(mutation.addedNodes.length, mutation.removedNodes.length);});});}", new Serializable[0]);
            this.notifyClient();
        }));
    }

    private void notifyClient() {
        this.getElement().executeJs(this.isActive() ? "$0.observer.observe($0, {attributes: false, childList: true, subtree: true});" : "$0.observer.disconnect();", new Serializable[0]);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.notifyClient();
    }

    @Override
    public Registration addContentChangeListener(ContentChangeListener listener) {
        return this.getEventBus().addListener(ContentChangeEvent.class, (ComponentEventListener)listener);
    }
}

